/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.icarusfell.diabloloot.Main;
import com.icarusfell.diabloloot.resource.CompatibleItemEntry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class CompatibleItemRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/diabloloot");
    public static CompatibleItemEntry COMPATIBLE_ITEM_ENTRY;

    public static void loadResourceEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            String[] items = new String[]{"minecraft:leather_helmet:0-15", "minecraft:leather_chestplate:0-15", "minecraft:leather_leggings:0-15", "minecraft:leather_boots:0-15", "minecraft:wooden_sword:0-15", "minecraft:wooden_axe:0-15", "minecraft:chainmail_helmet:15-30", "minecraft:chainmail_chestplate:15-30", "minecraft:chainmail_leggings:15-30", "minecraft:chainmail_boots:15-30", "minecraft:stone_sword:15-30", "minecraft:stone_axe:15-30", "minecraft:turtle_helmet:15-30", "minecraft:golden_helmet:30-45", "minecraft:golden_chestplate:30-45", "minecraft:golden_leggings:30-45", "minecraft:golden_boots:30-45", "minecraft:golden_sword:30-45", "minecraft:golden_axe:30-45", "minecraft:iron_helmet:45-60", "minecraft:iron_chestplate:45-60", "minecraft:iron_leggings:45-60", "minecraft:iron_boots:45-60", "minecraft:iron_sword:45-60", "minecraft:iron_axe:45-60", "minecraft:diamond_helmet:60-80", "minecraft:diamond_chestplate:60-80", "minecraft:diamond_leggings:60-80", "minecraft:diamond_boots:60-80", "minecraft:diamond_sword:60-80", "minecraft:diamond_axe:60-80", "minecraft:netherite_helmet:80-100", "minecraft:netherite_chestplate:80-100", "minecraft:netherite_leggings:80-100", "minecraft:netherite_boots:80-100", "minecraft:netherite_sword:80-100", "minecraft:netherite_axe:80-100", "minecraft:bow:0-100"};
            COMPATIBLE_ITEM_ENTRY = new CompatibleItemEntry(items);
            try (FileWriter writer = new FileWriter(new File(JSON_DIR, "compatible_items.json"));){
                GSON.toJson((Object)COMPATIBLE_ITEM_ENTRY, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    CompatibleItemEntry entry = (CompatibleItemEntry)GSON.fromJson((Reader)json, CompatibleItemEntry.class);
                    if (entry != null) {
                        COMPATIBLE_ITEM_ENTRY = entry;
                        continue;
                    }
                    Main.LOGGER.error("Could not load diabloloot entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the diabloloot config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

