/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.slayerconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.icarusfell.diabloloot.Main;
import com.icarusfell.diabloloot.slayerconfig.SlayerEntry;
import com.icarusfell.diabloloot.slayerconfig.SlayerExampleBosses;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class SlayerRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/diabloloot/bosses");
    public static final Map<String, SlayerEntry> SLAYER_ENTRIES = new HashMap<String, SlayerEntry>();

    public static void loadSlayerEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            ArrayList<SlayerEntry> entries = new ArrayList<SlayerEntry>();
            entries.add(SlayerExampleBosses.jerry_the_butcherer);
            entries.add(SlayerExampleBosses.black_widow);
            for (SlayerEntry entry : entries) {
                SLAYER_ENTRIES.put(entry.getId(), entry);
                try {
                    FileWriter writer = new FileWriter(new File(JSON_DIR, entry.getId() + ".json"));
                    Throwable throwable = null;
                    try {
                        GSON.toJson((Object)entry, (Appendable)writer);
                        writer.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        SLAYER_ENTRIES.clear();
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    SlayerEntry entry = (SlayerEntry)GSON.fromJson((Reader)json, SlayerEntry.class);
                    if (entry != null) {
                        SLAYER_ENTRIES.put(entry.getId(), entry);
                        continue;
                    }
                    Main.LOGGER.error("Could not load slayer entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the slayer config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

