/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.slayergui;

import com.icarusfell.diabloloot.Main;
import com.icarusfell.diabloloot.handlers.HUDS;
import com.icarusfell.diabloloot.handlers.MethodHandler;
import com.icarusfell.diabloloot.items.SlayerBook;
import com.icarusfell.diabloloot.network.Networking;
import com.icarusfell.diabloloot.network.StartHunt;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SlayerScreen
extends Screen {
    private ResourceLocation GUI = new ResourceLocation("diabloloot", "textures/gui/slayer_gui.png");
    protected ITextComponent previous = new StringTextComponent("<-");
    protected ITextComponent next = new StringTextComponent("->");
    protected ITextComponent hunt = new StringTextComponent("Hunt!");
    private float oldMouseX;
    private float oldMouseY;
    protected int x = 158;
    protected int y = 181;
    public boolean hasPhysicalDamage = false;
    public int physicalDamage;
    public boolean hasFireDamage = false;
    public int fireDamage;
    public boolean hasIceDamage = false;
    public int iceDamage;
    public boolean hasChaosDamage = false;
    public int chaosDamage;
    public boolean hasPhysicalArmor = false;
    public int physicalArmor;
    public boolean hasFireArmor = false;
    public int fireArmor;
    public boolean hasIceArmor = false;
    public int iceArmor;
    public boolean hasChaosArmor = false;
    public int chaosArmor;
    public boolean hasHealth = false;
    public int health;
    public boolean hasLevel = false;
    public int level;
    public int pageId;
    public boolean lastPage = false;
    public boolean isLeaping;
    public boolean isSmacking;
    public boolean isThrusting;
    public boolean isDodging;
    public boolean isDashing;
    public Entity entity;
    public EntityType<?> entityType;
    public int mobSize;
    public String name;
    public String id;
    public int color;
    public String mainhand = "minecraft:air";
    public String offhand = "minecraft:air";
    public String helmet = "minecraft:air";
    public String chestplate = "minecraft:air";
    public String leggings = "minecraft:air";
    public String boots = "minecraft:air";

    public SlayerScreen(EntityType<?> entityType) {
        super((ITextComponent)new StringTextComponent("slayer"));
        this.entityType = entityType;
        this.entity = entityType.func_200721_a(Main.proxy.getClientWorld());
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addPreviousButton();
        this.addNextButton();
        this.addHuntButton();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        matrixStack.func_227860_a_();
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        this.getMinecraft().func_110434_K().func_110577_a(this.GUI);
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, this.x, this.y);
        matrixStack.func_227865_b_();
        this.drawStats(matrixStack);
        this.drawEntity();
        if (!this.isPlayerValid()) {
            this.drawNonValid(matrixStack);
        }
        this.drawName(matrixStack);
        this.drawPlayerStats();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    private void drawEntity() {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        this.entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.mainhand)));
        this.entity.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.offhand)));
        this.entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.helmet)));
        this.entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.chestplate)));
        this.entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.leggings)));
        this.entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)MethodHandler.getItemFromString(this.boots)));
        InventoryScreen.func_228187_a_((int)(relX + 41), (int)(relY + 67), (int)this.mobSize, (float)((float)(relX + 51) - this.oldMouseX), (float)((float)(relY + 75 - 50) - this.oldMouseY), (LivingEntity)((LivingEntity)this.entity));
    }

    private void drawName(MatrixStack matrixStack) {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        int stringWidthValue = this.field_230712_o_.func_78256_a(this.name);
        this.field_230712_o_.func_238405_a_(matrixStack, this.name, (float)(relX + 78 - stringWidthValue / 2), (float)(relY + -17), this.color);
    }

    public void drawStats(MatrixStack matrixStack) {
        this.drawIcons(matrixStack);
        this.drawText(matrixStack);
    }

    private void drawNonValid(MatrixStack matrixStack) {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        matrixStack.func_227860_a_();
        this.field_230712_o_.func_238405_a_(matrixStack, "Level " + this.level, (float)(relX + 95), (float)(relY + 43), 0xFF3737);
        this.field_230712_o_.func_238405_a_(matrixStack, "required.", (float)(relX + 94), (float)(relY + 55), 0xFF3737);
        matrixStack.func_227865_b_();
    }

    private void drawIcons(MatrixStack matrixStack) {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        int firstTopLeftX = 4;
        int firstTopLeftY = 81;
        if (this.hasHealth) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + firstTopLeftX, relY + firstTopLeftY, 0, 1, 16, 15);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            firstTopLeftY += 20;
        }
        if (this.hasPhysicalArmor) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + firstTopLeftX, relY + firstTopLeftY, 17, 0, 14, 16);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            firstTopLeftY += 20;
        }
        if (this.hasIceArmor) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + firstTopLeftX, relY + firstTopLeftY, 33, 0, 14, 16);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            firstTopLeftY += 20;
        }
        if (this.hasFireArmor) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + firstTopLeftX, relY + firstTopLeftY, 49, 0, 14, 16);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            firstTopLeftY += 20;
        }
        if (this.hasChaosArmor) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + firstTopLeftX, relY + firstTopLeftY, 65, 0, 14, 16);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            firstTopLeftY += 20;
        }
        int secondTopLeftX = 82;
        int secondTopLeftY = 81;
        if (this.hasLevel) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + secondTopLeftX, relY + secondTopLeftY, 138, 2, 18, 15);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            secondTopLeftY += 19;
        }
        if (this.hasPhysicalDamage) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + secondTopLeftX, relY + secondTopLeftY, 0, 18, 18, 17);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            secondTopLeftY += 20;
        }
        if (this.hasIceDamage) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + secondTopLeftX, relY + secondTopLeftY, 39, 18, 18, 17);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            secondTopLeftY += 20;
        }
        if (this.hasFireDamage) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + secondTopLeftX, relY + secondTopLeftY, 59, 18, 18, 17);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            secondTopLeftY += 20;
        }
        if (this.hasChaosDamage) {
            matrixStack.func_227860_a_();
            this.getMinecraft().func_110434_K().func_110577_a(HUDS.ICONS);
            this.func_238474_b_(matrixStack, relX + secondTopLeftX, relY + secondTopLeftY, 79, 18, 18, 17);
            this.getMinecraft().func_110434_K().func_147645_c(HUDS.ICONS);
            matrixStack.func_227865_b_();
            secondTopLeftY += 20;
        }
    }

    private void drawText(MatrixStack matrixStack) {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        int firstTopLeftX = 23;
        int firstTopLeftY = 84;
        String str = "";
        if (this.hasHealth) {
            str = "" + this.health;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + firstTopLeftX), (float)(relY + firstTopLeftY), 0xFF3737);
            firstTopLeftY += 20;
        }
        if (this.hasPhysicalArmor) {
            str = "" + this.physicalArmor;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + firstTopLeftX), (float)(relY + firstTopLeftY), 0x7E7E7E);
            firstTopLeftY += 20;
        }
        if (this.hasIceArmor) {
            str = "" + this.iceArmor;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + firstTopLeftX), (float)(relY + firstTopLeftY), 131056);
            firstTopLeftY += 20;
        }
        if (this.hasFireArmor) {
            str = "" + this.fireArmor;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + firstTopLeftX), (float)(relY + firstTopLeftY), 16742401);
            firstTopLeftY += 20;
        }
        if (this.hasChaosArmor) {
            str = "" + this.chaosArmor;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + firstTopLeftX), (float)(relY + firstTopLeftY), 57678);
            firstTopLeftY += 20;
        }
        int secondTopLeftX = 103;
        int secondTopLeftY = 84;
        if (this.hasLevel) {
            str = "" + this.level;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + secondTopLeftX), (float)(relY + secondTopLeftY), 0xF7FF00);
            secondTopLeftY += 20;
        }
        if (this.hasPhysicalDamage) {
            str = "" + this.physicalDamage;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + secondTopLeftX), (float)(relY + secondTopLeftY), 0x7E7E7E);
            secondTopLeftY += 20;
        }
        if (this.hasIceDamage) {
            str = "" + this.iceDamage;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + secondTopLeftX), (float)(relY + secondTopLeftY), 131056);
            secondTopLeftY += 20;
        }
        if (this.hasFireDamage) {
            str = "" + this.fireDamage;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + secondTopLeftX), (float)(relY + secondTopLeftY), 16742401);
            secondTopLeftY += 20;
        }
        if (this.hasChaosDamage) {
            str = "" + this.chaosDamage;
            this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(relX + secondTopLeftX), (float)(relY + secondTopLeftY), 57678);
            secondTopLeftY += 20;
        }
    }

    public void drawPlayerStats() {
    }

    public void addPreviousButton() {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        if (this.pageId == 1) {
            return;
        }
        int previousId = this.pageId - 1;
        SlayerScreen screenFromMap = Minecraft.func_71410_x().func_71356_B() ? SlayerBook.defaultScreenMap.get(previousId) : SlayerBook.serverScreenMap.get(previousId);
        this.func_230480_a_((Widget)new Button(relX - 20, relY + 161, 20, 20, this.previous, button -> this.getMinecraft().func_147108_a((Screen)screenFromMap)));
    }

    public void addNextButton() {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        if (this.lastPage) {
            return;
        }
        int nextId = this.pageId + 1;
        SlayerScreen screenFromMap = Minecraft.func_71410_x().func_71356_B() ? SlayerBook.defaultScreenMap.get(nextId) : SlayerBook.serverScreenMap.get(nextId);
        this.func_230480_a_((Widget)new Button(relX + 158, relY + 161, 20, 20, this.next, button -> this.getMinecraft().func_147108_a((Screen)screenFromMap)));
    }

    private void addHuntButton() {
        int relX = (this.field_230708_k_ - this.x) / 2;
        int relY = (this.field_230709_l_ - this.y) / 2;
        if (this.isPlayerValid()) {
            this.func_230480_a_((Widget)new Button(relX + 95, relY + 43, 40, 20, this.hunt, button -> {
                Networking.INSTANCE.sendToServer((Object)new StartHunt(this.health, this.level, this.physicalArmor, this.fireArmor, this.iceArmor, this.chaosArmor, this.physicalDamage, this.fireDamage, this.iceDamage, this.chaosDamage, this.isLeaping, this.isSmacking, this.isThrusting, this.isDodging, this.isDashing, this.entityType.toString(), this.name, this.id, this.mainhand, this.offhand, this.helmet, this.chestplate, this.leggings, this.boots));
                Minecraft.func_71410_x().func_147108_a(null);
            }));
        }
    }

    public SlayerScreen setHealth(int value) {
        this.hasHealth = true;
        this.health = value;
        return this;
    }

    public SlayerScreen setPhysicalDamage(int value) {
        this.hasPhysicalDamage = true;
        this.physicalDamage = value;
        return this;
    }

    public SlayerScreen setFireDamage(int value) {
        this.hasFireDamage = true;
        this.fireDamage = value;
        return this;
    }

    public SlayerScreen setIceDamage(int value) {
        this.hasIceDamage = true;
        this.iceDamage = value;
        return this;
    }

    public SlayerScreen setChaosDamage(int value) {
        this.hasChaosDamage = true;
        this.chaosDamage = value;
        return this;
    }

    public SlayerScreen setLevel(int value) {
        this.hasLevel = true;
        this.level = value;
        return this;
    }

    public SlayerScreen setPhysicalArmor(int value) {
        this.hasPhysicalArmor = true;
        this.physicalArmor = value;
        return this;
    }

    public SlayerScreen setFireArmor(int value) {
        this.hasFireArmor = true;
        this.fireArmor = value;
        return this;
    }

    public SlayerScreen setIceArmor(int value) {
        this.hasIceArmor = true;
        this.iceArmor = value;
        return this;
    }

    public SlayerScreen setChaosArmor(int value) {
        this.hasChaosArmor = true;
        this.chaosArmor = value;
        return this;
    }

    public SlayerScreen setEntity(Entity entity) {
        this.entity = entity;
        return this;
    }

    public SlayerScreen setPageId(int value) {
        this.pageId = value;
        return this;
    }

    public SlayerScreen setSize(int value) {
        this.mobSize = value;
        return this;
    }

    public SlayerScreen setName(String str) {
        this.name = str;
        return this;
    }

    public SlayerScreen setNameColor(int value) {
        this.color = value;
        return this;
    }

    public SlayerScreen setLastPage(boolean flag) {
        this.lastPage = flag;
        return this;
    }

    public SlayerScreen setLeaping(boolean flag) {
        this.isLeaping = flag;
        return this;
    }

    public SlayerScreen setSmacking(boolean flag) {
        this.isSmacking = flag;
        return this;
    }

    public SlayerScreen setThrusting(boolean flag) {
        this.isThrusting = flag;
        return this;
    }

    public SlayerScreen setDodging(boolean flag) {
        this.isDodging = flag;
        return this;
    }

    public SlayerScreen setDashing(boolean flag) {
        this.isDashing = flag;
        return this;
    }

    public SlayerScreen setId(String str) {
        this.id = str;
        return this;
    }

    public SlayerScreen setMainhand(String str) {
        this.mainhand = str;
        return this;
    }

    public SlayerScreen setOffhand(String str) {
        this.offhand = str;
        return this;
    }

    public SlayerScreen setHelmet(String str) {
        this.helmet = str;
        return this;
    }

    public SlayerScreen setChestplate(String str) {
        this.chestplate = str;
        return this;
    }

    public SlayerScreen setLeggings(String str) {
        this.leggings = str;
        return this;
    }

    public SlayerScreen setBoots(String str) {
        this.boots = str;
        return this;
    }

    public EntityType<?> getEntityType() {
        return this.getEntityType();
    }

    public boolean isPlayerValid() {
        return Main.proxy.getClientPlayer().getPersistentData().func_74762_e("diablolootlevel") >= this.level;
    }
}

