/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.uniqueconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.icarusfell.diabloloot.Main;
import com.icarusfell.diabloloot.uniqueconfig.UniqueItemEntry;
import com.icarusfell.diabloloot.uniqueconfig.UniqueItems;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class UniqueItemRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/diabloloot/uniques");
    public static final Map<String, UniqueItemEntry> UNIQUE_ITEM_ENTRIES = new HashMap<String, UniqueItemEntry>();

    public static void loadUniqueItemEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            ArrayList<UniqueItemEntry> entries = new ArrayList<UniqueItemEntry>();
            entries.add(UniqueItems.example_sword);
            entries.add(UniqueItems.example_armor);
            for (UniqueItemEntry entry : entries) {
                UNIQUE_ITEM_ENTRIES.put(entry.getId(), entry);
                try {
                    FileWriter writer = new FileWriter(new File(JSON_DIR, entry.getId() + ".json"));
                    Throwable throwable = null;
                    try {
                        GSON.toJson((Object)entry, (Appendable)writer);
                        writer.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        UNIQUE_ITEM_ENTRIES.clear();
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    UniqueItemEntry entry = (UniqueItemEntry)GSON.fromJson((Reader)json, UniqueItemEntry.class);
                    if (entry != null) {
                        UNIQUE_ITEM_ENTRIES.put(entry.getId(), entry);
                        continue;
                    }
                    Main.LOGGER.error("Could not load uniqueitem entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the uniqueitem config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

