/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot;

import com.icarusfell.diabloloot.blocks.CurrencyStash;
import com.icarusfell.diabloloot.blocks.CurrencyStashContainer;
import com.icarusfell.diabloloot.blocks.CurrencyStashTile;
import com.icarusfell.diabloloot.blocks.GemTable;
import com.icarusfell.diabloloot.blocks.GemTableContainer;
import com.icarusfell.diabloloot.blocks.GemTableTile;
import com.icarusfell.diabloloot.blocks.MagicTable;
import com.icarusfell.diabloloot.blocks.MagicTableContainer;
import com.icarusfell.diabloloot.blocks.MagicTableTile;
import com.icarusfell.diabloloot.blocks.ModBlocks;
import com.icarusfell.diabloloot.handlers.GemSkillHandler;
import com.icarusfell.diabloloot.handlers.MobDropsHandler;
import com.icarusfell.diabloloot.handlers.MobSpawnHandler;
import com.icarusfell.diabloloot.handlers.NewDamageHandler;
import com.icarusfell.diabloloot.handlers.TooltipHandler;
import com.icarusfell.diabloloot.items.BookOfSkill;
import com.icarusfell.diabloloot.items.Currency;
import com.icarusfell.diabloloot.items.SkillGem;
import com.icarusfell.diabloloot.lists.ItemList;
import com.icarusfell.diabloloot.network.Networking;
import com.icarusfell.diabloloot.setup.ClientProxy;
import com.icarusfell.diabloloot.setup.IProxy;
import com.icarusfell.diabloloot.setup.ServerProxy;
import com.icarusfell.diabloloot.skillpointgui.SkillBookContainer;
import com.icarusfell.diabloloot.tabs.DiabloCurrencyLootTab;
import com.icarusfell.diabloloot.tabs.DiabloLootTab;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="diabloloot")
public class Main {
    public static Main instance;
    public static final String MODID = "diabloloot";
    public static IProxy proxy;
    public static final Logger LOGGER;
    public static final ItemGroup DIABLOLOOTTAB;
    public static final ItemGroup DIABLOCURRENCYLOOTTAB;
    public static final int MAX_LEVEL = 10;
    public static final int HIT_REQUIRED = 150;

    public Main() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobDropsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new NewDamageHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobSpawnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GemSkillHandler());
        proxy.init();
        Networking.registerMessages();
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
    }

    private void client(FMLClientSetupEvent event) {
    }

    public static int returnIntegerBetween(int maxValue, int minValue) {
        return new Random().nextInt(maxValue - minValue + 1) + minValue;
    }

    public static boolean readyToLevelUp(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("hits") >= stack.func_77978_p().func_74762_e("hitsRequired") && stack.func_77978_p().func_74762_e("level") < stack.func_77978_p().func_74762_e("maxLevel");
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        LOGGER = LogManager.getLogger((String)MODID);
        DIABLOLOOTTAB = new DiabloLootTab();
        DIABLOCURRENCYLOOTTAB = new DiabloCurrencyLootTab();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemList.alteration_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(40)).setRegistryName(new ResourceLocation(Main.MODID, "alteration_orb")), ItemList.transmutation_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(40)).setRegistryName(new ResourceLocation(Main.MODID, "transmutation_orb")), ItemList.enforcing_crystal = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(20)).setRegistryName(new ResourceLocation(Main.MODID, "enforcing_crystal")), ItemList.chaos_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(30)).setRegistryName(new ResourceLocation(Main.MODID, "chaos_orb")), ItemList.corruption_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(20)).setRegistryName(new ResourceLocation(Main.MODID, "corruption_orb")), ItemList.emperors_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(30)).setRegistryName(new ResourceLocation(Main.MODID, "emperors_orb")), ItemList.exalted_orb = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(10)).setRegistryName(new ResourceLocation(Main.MODID, "exalted_orb")), ItemList.mirror_of_cubeland = (Item)new Currency(new Item.Properties().func_200916_a(DIABLOCURRENCYLOOTTAB).func_200917_a(10)).setRegistryName(new ResourceLocation(Main.MODID, "mirror_of_cubeland")), ItemList.info = (Item)new Item(new Item.Properties().func_200916_a(null).func_200917_a(1)).setRegistryName(new ResourceLocation(Main.MODID, "info")), ItemList.book_of_skills = (Item)new BookOfSkill(new Item.Properties().func_200916_a(DIABLOLOOTTAB)).setRegistryName(new ResourceLocation(Main.MODID, "book_of_skills")), ItemList.skill_gem = (Item)new SkillGem(new Item.Properties().func_200916_a(DIABLOLOOTTAB).func_200917_a(1)).setRegistryName(new ResourceLocation(Main.MODID, "skill_gem")), ItemList.gemtable = (Item)new BlockItem((Block)ModBlocks.GEMTABLE, new Item.Properties().func_200916_a(DIABLOLOOTTAB)).setRegistryName(new GemTable().getRegistryName()), ItemList.currencystash = (Item)new BlockItem((Block)ModBlocks.CURRENCYSTASH, new Item.Properties().func_200916_a(DIABLOLOOTTAB)).setRegistryName(new CurrencyStash().getRegistryName()), ItemList.magictable = (Item)new BlockItem((Block)ModBlocks.MAGICTABLE, new Item.Properties().func_200916_a(DIABLOLOOTTAB)).setRegistryName(new MagicTable().getRegistryName())});
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register((IForgeRegistryEntry)new MagicTable());
            event.getRegistry().register((IForgeRegistryEntry)new GemTable());
            event.getRegistry().register((IForgeRegistryEntry)new CurrencyStash());
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(MagicTableTile::new, (Block[])new Block[]{ModBlocks.MAGICTABLE}).func_206865_a(null).setRegistryName("magictable"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(GemTableTile::new, (Block[])new Block[]{ModBlocks.GEMTABLE}).func_206865_a(null).setRegistryName("gemtable"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CurrencyStashTile::new, (Block[])new Block[]{ModBlocks.CURRENCYSTASH}).func_206865_a(null).setRegistryName("currencystash"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new MagicTableContainer(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("magictable"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new GemTableContainer(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("gemtable"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new CurrencyStashContainer(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("currencystash"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new SkillBookContainer(windowId, proxy.getClientWorld(), inv, proxy.getClientPlayer())).setRegistryName("skillbook"));
        }
    }
}

