/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomArmorHandler {
    private Item getRandomItem(Collection<Item> collection) {
        HashSet<Item> newcollection = new HashSet<Item>();
        newcollection.addAll(collection);
        Iterator it = newcollection.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (item instanceof ArmorItem) continue;
            it.remove();
        }
        Random rnd = new Random();
        int i = rnd.nextInt(newcollection.size());
        return (Item)newcollection.toArray()[i];
    }

    public ItemStack returnRandomArmor() {
        Collection itemcollection = ForgeRegistries.ITEMS.getValues();
        ItemStack i = new ItemStack((IItemProvider)this.getRandomItem(itemcollection));
        return i;
    }

    public void hideVanillaModifiers(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("HideFlags", 63);
            stack.func_77978_p().func_74757_a("Unbreakable", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("HideFlags", 63);
            stack.func_77978_p().func_74757_a("Unbreakable", true);
        }
    }

    public void setRandomUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            String rUUID = UUID.randomUUID().toString();
            stack.func_77978_p().func_74778_a("IUUID", rUUID);
        } else {
            stack.func_77982_d(new CompoundNBT());
            String rUUID = UUID.randomUUID().toString();
            stack.func_77978_p().func_74778_a("IUUID", rUUID);
        }
    }

    public void setItemLevel(ItemStack stack, int level) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("level", level);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("level", level);
        }
    }

    public int getLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("level");
        }
        return 0;
    }

    public void setRandomTier(ItemStack stack, int commonchance, int uncommonchance, int magicchance, int extraordchance, int legendarychance) {
        if (stack.func_77942_o()) {
            if (new Random().nextInt(100) + 1 < commonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            } else if (new Random().nextInt(100) + 1 < uncommonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 2);
            } else if (new Random().nextInt(100) + 1 < magicchance) {
                stack.func_77978_p().func_74768_a("itemTier", 3);
            } else if (new Random().nextInt(100) + 1 < extraordchance) {
                stack.func_77978_p().func_74768_a("itemTier", 4);
            } else if (new Random().nextInt(100) + 1 < legendarychance) {
                stack.func_77978_p().func_74768_a("itemTier", 5);
            } else {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (new Random().nextInt(100) + 1 < commonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            } else if (new Random().nextInt(100) + 1 < uncommonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 2);
            } else if (new Random().nextInt(100) + 1 < magicchance) {
                stack.func_77978_p().func_74768_a("itemTier", 3);
            } else if (new Random().nextInt(100) + 1 < extraordchance) {
                stack.func_77978_p().func_74768_a("itemTier", 4);
            } else if (new Random().nextInt(100) + 1 < legendarychance) {
                stack.func_77978_p().func_74768_a("itemTier", 5);
            } else {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            }
        }
    }

    public void setStackName(ItemStack stack, String newname) {
        StringTextComponent textcomponent = new StringTextComponent(newname);
        stack.func_200302_a((ITextComponent)textcomponent);
    }

    public void setTier(ItemStack stack, int tier) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("itemTier", tier);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("itemTier", tier);
        }
    }

    public int getTier(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("itemTier");
        }
        return 0;
    }

    public void setToBeModified(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("canBeModifiedArmor", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("canBeModifiedArmor", true);
        }
    }

    public void setPhysicalArmor(ItemStack stack, double armor) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("physicalArmor", armor);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("physicalArmor", armor);
        }
    }

    public void setHP(ItemStack stack, double health) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("hp", health);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("hp", health);
        }
    }

    public void setFireArmor(ItemStack stack, double Armor) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("fireArmor", Armor);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("fireArmor", Armor);
        }
    }

    public void setIceArmor(ItemStack stack, double Armor) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("iceArmor", Armor);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("iceArmor", Armor);
        }
    }

    public void setChaosArmor(ItemStack stack, double Armor) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("chaosArmor", Armor);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("chaosArmor", Armor);
        }
    }

    public void addPhysicalArmor(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("physicalArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("physicalArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("physicalArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("physicalArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addFireArmor(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("fireArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("fireArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("fireArmorInc+", value);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("fireArmorInc&", value);
            }
        }
    }

    public void addIceArmor(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("iceArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("iceArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("iceArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("iceArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addChaosArmor(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("chaosArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("chaosArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("chaosArmorInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("chaosArmorInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addHP(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("hpInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("hpInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("hpInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("hpInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void setCustomName(ItemStack stack) {
        String tierColor_ = "";
        if (this.getTier(stack) == 1) {
            tierColor_ = "\u00a77";
        }
        if (this.getTier(stack) == 2) {
            tierColor_ = "\u00a7a";
        }
        if (this.getTier(stack) == 3) {
            tierColor_ = "\u00a71";
        }
        if (this.getTier(stack) == 4) {
            tierColor_ = "\u00a7d";
        }
        if (this.getTier(stack) == 5) {
            tierColor_ = "\u00a76";
        }
        String suffix_ = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fireArmor")) {
            suffix_ = " of Fire";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("iceArmor")) {
            suffix_ = " of Ice";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("chaosArmor")) {
            suffix_ = " of Chaos";
        }
        String baseName_ = stack.func_200301_q().func_150254_d();
        stack.func_77978_p().func_74778_a("uncoloredName", baseName_ + suffix_);
        stack.func_77978_p().func_74778_a("tierColor", tierColor_);
        stack.func_200302_a((ITextComponent)new StringTextComponent(tierColor_ + baseName_ + suffix_));
    }

    public void addCustomModifiers(ItemStack stack) {
        this.setPhysicalArmor(stack, (double)new Random().nextInt(7) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addPhysicalArmor(stack, (double)new Random().nextInt(4) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
            } else {
                this.addPhysicalArmor(stack, (double)(new Random().nextInt(16) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
            }
        }
        if (new Random().nextInt(2) + 1 == 1) {
            int i = new Random().nextInt(3) + 1;
            if (i == 1) {
                this.setFireArmor(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addFireArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addFireArmor(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 2) {
                this.setIceArmor(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addIceArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addIceArmor(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 3) {
                this.setChaosArmor(stack, (double)new Random().nextInt(3) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addChaosArmor(stack, (double)new Random().nextInt(2) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addChaosArmor(stack, (double)(new Random().nextInt(12) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            }
        }
        this.setHP(stack, (double)new Random().nextInt(7) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addHP(stack, (double)new Random().nextInt(4) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
            } else {
                this.addHP(stack, (double)(new Random().nextInt(16) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
            }
        }
    }

    public void drop(ItemStack stack, Entity entity, World world) {
        ItemEntity ie = new ItemEntity(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_200301_q());
        ie.func_174805_g(true);
    }
}

