/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomWeaponHandler {
    private Item getRandomItem(Collection<Item> collection) {
        HashSet<Item> newcollection = new HashSet<Item>();
        newcollection.addAll(collection);
        Iterator it = newcollection.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (item instanceof AxeItem || item instanceof SwordItem) continue;
            it.remove();
        }
        Random rnd = new Random();
        int i = rnd.nextInt(newcollection.size());
        return (Item)newcollection.toArray()[i];
    }

    public ItemStack returnRandomWeapon() {
        Collection itemcollection = ForgeRegistries.ITEMS.getValues();
        ItemStack i = new ItemStack((IItemProvider)this.getRandomItem(itemcollection));
        return i;
    }

    public void hideVanillaModifiers(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("HideFlags", 63);
            stack.func_77978_p().func_74757_a("Unbreakable", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("HideFlags", 63);
            stack.func_77978_p().func_74757_a("Unbreakable", true);
        }
    }

    public void setItemLevel(ItemStack stack, int level) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("level", level);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("level", level);
        }
    }

    public int getLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("level");
        }
        return 0;
    }

    public void setRandomTier(ItemStack stack, int commonchance, int uncommonchance, int magicchance, int extraordchance, int legendarychance) {
        if (stack.func_77942_o()) {
            if (new Random().nextInt(100) + 1 < commonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            } else if (new Random().nextInt(100) + 1 < uncommonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 2);
            } else if (new Random().nextInt(100) + 1 < magicchance) {
                stack.func_77978_p().func_74768_a("itemTier", 3);
            } else if (new Random().nextInt(100) + 1 < extraordchance) {
                stack.func_77978_p().func_74768_a("itemTier", 4);
            } else if (new Random().nextInt(100) + 1 < legendarychance) {
                stack.func_77978_p().func_74768_a("itemTier", 5);
            } else {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (new Random().nextInt(100) + 1 < commonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            } else if (new Random().nextInt(100) + 1 < uncommonchance) {
                stack.func_77978_p().func_74768_a("itemTier", 2);
            } else if (new Random().nextInt(100) + 1 < magicchance) {
                stack.func_77978_p().func_74768_a("itemTier", 3);
            } else if (new Random().nextInt(100) + 1 < extraordchance) {
                stack.func_77978_p().func_74768_a("itemTier", 4);
            } else if (new Random().nextInt(100) + 1 < legendarychance) {
                stack.func_77978_p().func_74768_a("itemTier", 5);
            } else {
                stack.func_77978_p().func_74768_a("itemTier", 1);
            }
        }
    }

    public void setStackName(ItemStack stack, String newname) {
        StringTextComponent textcomponent = new StringTextComponent(newname);
        stack.func_200302_a((ITextComponent)textcomponent);
    }

    public void setTier(ItemStack stack, int tier) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("itemTier", tier);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("itemTier", tier);
        }
    }

    public int getTier(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("itemTier");
        }
        return 0;
    }

    public void setToBeModified(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("canBeModifiedWeapon", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("canBeModifiedWeapon", true);
        }
    }

    public void setPhysicalDamage(ItemStack stack, double damage) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("physicalDamage", damage);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("physicalDamage", damage);
        }
    }

    public void setFireDamage(ItemStack stack, double damage) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("fireDamage", damage);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("fireDamage", damage);
        }
    }

    public void setIceDamage(ItemStack stack, double damage) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("iceDamage", damage);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("iceDamage", damage);
        }
    }

    public void setChaosDamage(ItemStack stack, double damage) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74780_a("chaosDamage", damage);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74780_a("chaosDamage", damage);
        }
    }

    public void addPhysicalDamage(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("physicalDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("physicalDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("physicalDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("physicalDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addFireDamage(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("fireDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("fireDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("fireDamageInc+", value);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("fireDamageInc&", value);
            }
        }
    }

    public void addIceDamage(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("iceDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("iceDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("iceDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("iceDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addChaosDamage(ItemStack stack, double value, int type) {
        if (stack.func_77942_o()) {
            if (type == 0) {
                stack.func_77978_p().func_74780_a("chaosDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("chaosDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        } else {
            stack.func_77982_d(new CompoundNBT());
            if (type == 0) {
                stack.func_77978_p().func_74780_a("chaosDamageInc+", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
            if (type == 1) {
                stack.func_77978_p().func_74780_a("chaosDamageInc&", value);
                stack.func_77978_p().func_74757_a("secondModifier", true);
            }
        }
    }

    public void addLifesteal(ItemStack stack, int value) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("lifesteal", value);
            stack.func_77978_p().func_74757_a("secondModifier", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("lifesteal", value);
            stack.func_77978_p().func_74757_a("secondModifier", true);
        }
    }

    public void addLifeOnHit(ItemStack stack, int value) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("lifeOnHit", value);
            stack.func_77978_p().func_74757_a("secondModifier", true);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("lifeOnHit", value);
            stack.func_77978_p().func_74757_a("secondModifier", true);
        }
    }

    public void addCriticals(ItemStack stack, int min, int max, int tier) {
        Random rnd = new Random();
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("secondModifier", true);
            int critchance = rnd.nextInt(max - min + 1) + min;
            double critdamage = (double)(rnd.nextInt(11) + 10) / 8.0 + (double)tier / 5.0 + (double)((int)((double)this.getLevel(stack) / 10.0)) / 8.0;
            stack.func_77978_p().func_74768_a("critChance", critchance + tier * 2);
            stack.func_77978_p().func_74780_a("critDamage", critdamage);
        } else {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("secondModifier", true);
            int critchance = rnd.nextInt(max - min + 1) + min;
            double critdamage = (double)(rnd.nextInt(11) + 10) / 8.0 + (double)tier / 5.0;
            stack.func_77978_p().func_74768_a("critChance", critchance + tier * 2);
            stack.func_77978_p().func_74780_a("critDamage", critdamage);
        }
    }

    public void setCustomName(ItemStack stack) {
        String tierColor_ = "";
        if (this.getTier(stack) == 1) {
            tierColor_ = "\u00a77";
        }
        if (this.getTier(stack) == 2) {
            tierColor_ = "\u00a7a";
        }
        if (this.getTier(stack) == 3) {
            tierColor_ = "\u00a71";
        }
        if (this.getTier(stack) == 4) {
            tierColor_ = "\u00a7d";
        }
        if (this.getTier(stack) == 5) {
            tierColor_ = "\u00a76";
        }
        String suffix_ = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fireDamage")) {
            suffix_ = " of Fire";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("iceDamage")) {
            suffix_ = " of Ice";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("chaosDamage")) {
            suffix_ = " of Chaos";
        }
        String prefix_ = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("lifesteal")) {
            prefix_ = "Lifestealing ";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("lifeOnHit")) {
            prefix_ = "Lifeleeching ";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("critChance")) {
            prefix_ = "Critical Hitting ";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("critChance") && stack.func_77942_o() && stack.func_77978_p().func_74764_b("lifeOnHit")) {
            prefix_ = "Lifeleeching Critical Hitting";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("critChance") && stack.func_77942_o() && stack.func_77978_p().func_74764_b("lifesteal")) {
            prefix_ = "Lifestealing Critical Hitting";
        }
        String baseName_ = stack.func_200301_q().func_150254_d();
        stack.func_77978_p().func_74778_a("uncoloredName", prefix_ + baseName_ + suffix_);
        stack.func_77978_p().func_74778_a("tierColor", tierColor_);
        stack.func_77978_p().func_74778_a("baseName", baseName_);
        stack.func_200302_a((ITextComponent)new StringTextComponent(tierColor_ + prefix_ + baseName_ + tierColor_ + suffix_));
    }

    public void addCustomModifiers(ItemStack stack) {
        this.setPhysicalDamage(stack, (double)new Random().nextInt(7) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addPhysicalDamage(stack, (double)new Random().nextInt(4) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
            } else {
                this.addPhysicalDamage(stack, (double)(new Random().nextInt(16) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
            }
        }
        if (new Random().nextInt(2) + 1 == 1) {
            int i = new Random().nextInt(3) + 1;
            if (i == 1) {
                this.setFireDamage(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addFireDamage(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addFireDamage(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 2) {
                this.setIceDamage(stack, (double)new Random().nextInt(5) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addIceDamage(stack, (double)new Random().nextInt(3) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addIceDamage(stack, (double)(new Random().nextInt(14) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            } else if (i == 3) {
                this.setChaosDamage(stack, (double)new Random().nextInt(3) + 0.75 + (double)this.getTier(stack) / 4.0 + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + (double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack));
                if (new Random().nextInt(100) + 1 < 20) {
                    if (new Random().nextInt(2) + 1 == 1) {
                        this.addChaosDamage(stack, (double)new Random().nextInt(2) + 0.75 + (double)(this.getTier(stack) / 4) + (double)new Random().nextInt(this.getTier(stack)) + (double)this.getTier(stack) + ((double)new Random().nextInt(8) + 1.0) / 4.0 + ((double)this.getLevel(stack) * ((double)this.getTier(stack) / 4.0) + (double)this.getLevel(stack)) / 5.0, 0);
                    } else {
                        this.addChaosDamage(stack, (double)(new Random().nextInt(12) + 9) + 0.75 + (double)(this.getTier(stack) / 4), 1);
                    }
                }
            }
        }
        if (new Random().nextInt(100) + 1 < 20) {
            if (new Random().nextInt(2) + 1 == 1) {
                this.addLifesteal(stack, new Random().nextInt(7) + 5 + this.getTier(stack));
            } else {
                this.addLifeOnHit(stack, new Random().nextInt(3) + 2 + this.getTier(stack) + (int)((double)this.getLevel(stack) / 4.0));
            }
        }
        if (new Random().nextInt(100) + 1 < 20) {
            this.addCriticals(stack, 20, 45, this.getTier(stack));
        }
    }

    public void drop(ItemStack stack, Entity entity, World world) {
        ItemEntity ie = new ItemEntity(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        world.func_217376_c((Entity)ie);
        ie.func_200203_b(stack.func_200301_q());
        ie.func_174805_g(true);
    }
}

