/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.blocks;

import com.icarusfell.diabloloot.blocks.CurrencyStashContainer;
import com.icarusfell.diabloloot.blocks.ModBlocks;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CurrencyStashTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private int counter;
    private String ownerUUID;
    private String realUUID;
    private ItemStack currentStack;

    public CurrencyStashTile() {
        super(ModBlocks.CURRENCYSTASH_TILE);
    }

    public void func_73660_a() {
    }

    public void slotClick(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        CurrencyStashTile mytile = this;
        if (slotId < 8 && slotId >= 0) {
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                if (player.field_71071_by.func_70445_o().func_77973_b().equals(mytile.returnStackFromSlot(slotId).func_77973_b())) {
                    player.getPersistentData().func_74768_a("diablolootcurrency" + slotId, player.getPersistentData().func_74762_e("diablolootcurrency" + slotId) + player.field_71071_by.func_70445_o().func_190916_E());
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            } else if (player.getPersistentData().func_74762_e("diablolootcurrency" + slotId) > mytile.returnStackFromSlot(slotId).func_77976_d()) {
                player.field_71071_by.func_70437_b(new ItemStack((IItemProvider)mytile.returnStackFromSlot(slotId).func_77973_b(), mytile.returnStackFromSlot(slotId).func_77976_d()));
                player.getPersistentData().func_74768_a("diablolootcurrency" + slotId, player.getPersistentData().func_74762_e("diablolootcurrency" + slotId) - mytile.returnStackFromSlot(slotId).func_77976_d());
            } else if (player.getPersistentData().func_74762_e("diablolootcurrency" + slotId) <= mytile.returnStackFromSlot(slotId).func_77976_d()) {
                player.field_71071_by.func_70437_b(new ItemStack((IItemProvider)mytile.returnStackFromSlot(slotId).func_77973_b(), player.getPersistentData().func_74762_e("diablolootcurrency" + slotId)));
                player.getPersistentData().func_74768_a("diablolootcurrency" + slotId, 0);
            }
        }
    }

    public void setOwner(PlayerEntity player) {
        this.ownerUUID = player.getPersistentData().func_74779_i("diablolootstashUUID");
    }

    public void setRealPlayer(PlayerEntity player) {
        this.realUUID = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).toString();
    }

    public String getOwner() {
        return this.ownerUUID;
    }

    public String getRealPlayer() {
        return this.realUUID.isEmpty() ? "" : this.realUUID;
    }

    public ItemStack returnStackFromSlot(int slot) {
        this.handler.ifPresent(h -> {
            this.currentStack = h.getStackInSlot(slot);
        });
        return this.currentStack;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        this.counter = tag.func_74762_e("counter");
        this.ownerUUID = tag.func_74779_i("ownerUUID");
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        tag.func_74778_a("ownerUUID", this.ownerUUID);
        tag.func_74768_a("counter", this.counter);
        return super.func_189515_b(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                CurrencyStashTile.this.func_70296_d();
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                this.validateSlotIndex(slot);
                this.stacks.set(slot, (Object)stack);
                this.onContentsChanged(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return super.isItemValid(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CurrencyStashContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

