/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import com.ShantekMC.ServerNews;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JoinListener
implements Listener {
    private final ServerNews plugin;
    private final Map<UUID, List<Integer>> pendingTasks = new HashMap<UUID, List<Integer>>();
    private static final long FIRST_DELAY_TICKS = 600L;
    private static final long SECOND_DELAY_TICKS = 6000L;

    public JoinListener(ServerNews plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (!this.plugin.getNewsManager().hasNews()) {
            return;
        }
        if (this.plugin.getReadStore().hasRead(p.getUniqueId())) {
            return;
        }
        this.cancelPending(p.getUniqueId());
        int firstId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!p.isOnline()) {
                return;
            }
            if (!this.plugin.getNewsManager().hasNews()) {
                return;
            }
            if (this.plugin.getReadStore().hasRead(p.getUniqueId())) {
                return;
            }
            this.sendPrompt(p);
        }, 600L).getTaskId();
        int secondId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!p.isOnline()) {
                return;
            }
            if (!this.plugin.getNewsManager().hasNews()) {
                return;
            }
            if (this.plugin.getReadStore().hasRead(p.getUniqueId())) {
                return;
            }
            this.sendPrompt(p);
        }, 6000L).getTaskId();
        this.pendingTasks.put(p.getUniqueId(), new ArrayList<Integer>(Arrays.asList(firstId, secondId)));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.cancelPending(event.getPlayer().getUniqueId());
    }

    private void cancelPending(UUID uuid) {
        List<Integer> ids = this.pendingTasks.remove(uuid);
        if (ids == null) {
            return;
        }
        for (int id : ids) {
            Bukkit.getScheduler().cancelTask(id);
        }
    }

    private void sendPrompt(Player p) {
        p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.4f, 1.1f);
        p.sendMessage(String.valueOf(ChatColor.GRAY) + "Welcome, there's new server news. Read it with " + String.valueOf(ChatColor.GOLD) + "/news" + String.valueOf(ChatColor.GRAY) + ".");
    }
}

