/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import com.ShantekMC.ServerNews;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NewsCommand
implements CommandExecutor {
    private final ServerNews plugin;

    public NewsCommand(ServerNews plugin) {
        this.plugin = plugin;
    }

    private boolean isOpOrHas(CommandSender sender, String perm) {
        return sender.isOp() || sender.hasPermission(perm);
    }

    private void sendUsage(CommandSender sender, String label) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use /news to read the latest news from our server!");
        if (this.isOpOrHas(sender, "shantekmc.servernews.test")) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + String.valueOf(ChatColor.GOLD) + "/" + label + " test" + String.valueOf(ChatColor.GRAY) + "  - Preview testnews.yml (no read tracking)");
        }
        if (this.isOpOrHas(sender, "shantekmc.servernews.reset")) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + String.valueOf(ChatColor.GOLD) + "/" + label + " reset" + String.valueOf(ChatColor.GRAY) + " - Clear all readers (prompt on next join)");
        }
        if (this.isOpOrHas(sender, "shantekmc.servernews.list")) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + String.valueOf(ChatColor.GOLD) + "/" + label + " list" + String.valueOf(ChatColor.GRAY) + "  - Show reader count and names");
        }
        if (this.isOpOrHas(sender, "shantekmc.servernews.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + String.valueOf(ChatColor.GOLD) + "/" + label + " reload" + String.valueOf(ChatColor.GRAY) + " - Reload news.yml and testnews.yml");
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            String sub;
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "test": {
                    if (!this.isOpOrHas(sender, "shantekmc.servernews.test")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
                        return true;
                    }
                    List<String> test = this.plugin.getNewsManager().getTestNews();
                    if (test.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is no test news to show.");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "----- " + String.valueOf(ChatColor.GOLD) + "Test News" + String.valueOf(ChatColor.DARK_GRAY) + " -----");
                    for (String line : test) {
                        sender.sendMessage(line);
                    }
                    sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "-------------------------");
                    return true;
                }
                case "reset": {
                    if (!this.isOpOrHas(sender, "shantekmc.servernews.reset")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
                        return true;
                    }
                    this.plugin.getReadStore().reset();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ServerNews: Read list has been reset.");
                    return true;
                }
                case "list": {
                    if (!this.isOpOrHas(sender, "shantekmc.servernews.list")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
                        return true;
                    }
                    Set<UUID> all = this.plugin.getReadStore().all();
                    int count = all.size();
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Players who have read the news: " + String.valueOf(ChatColor.WHITE) + count);
                    if (count > 0) {
                        ArrayList<String> names = new ArrayList<String>();
                        for (UUID id : all) {
                            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)id);
                            String name = op != null ? op.getName() : null;
                            names.add(name != null ? name : id.toString());
                        }
                        sender.sendMessage(String.valueOf(ChatColor.GRAY) + String.join((CharSequence)(String.valueOf(ChatColor.WHITE) + ", " + String.valueOf(ChatColor.GRAY)), names));
                    }
                    return true;
                }
                case "reload": {
                    if (!this.isOpOrHas(sender, "shantekmc.servernews.reload")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
                        return true;
                    }
                    this.plugin.reloadConfig();
                    this.plugin.getNewsManager().reload();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ServerNews: config + news files reloaded.");
                    return true;
                }
            }
            this.sendUsage(sender, label);
            return true;
        }
        if (!(sender instanceof Player)) {
            List<String> news = this.plugin.getNewsManager().getNews();
            if (news.isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is currently no news to share.");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "----- " + String.valueOf(ChatColor.GOLD) + "Current News" + String.valueOf(ChatColor.DARK_GRAY) + " -----");
            for (String line : news) {
                sender.sendMessage(line);
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "---------------------------");
            return true;
        }
        Player p = (Player)sender;
        List<String> news = this.plugin.getNewsManager().getNews();
        if (news.isEmpty()) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "There is currently no news to share.");
            return true;
        }
        boolean hadAlreadyRead = this.plugin.getReadStore().hasRead(p.getUniqueId());
        this.plugin.getReadStore().markRead(p.getUniqueId());
        p.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "----- " + String.valueOf(ChatColor.GOLD) + "Server News" + String.valueOf(ChatColor.DARK_GRAY) + " -----");
        for (String line : news) {
            p.sendMessage(line);
        }
        p.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "---------------------------");
        if (!hadAlreadyRead) {
            FileConfiguration cfg = this.plugin.getConfig();
            int delaySeconds = cfg.getInt("reward.delay-seconds", 5);
            long delayTicks = (long)Math.max(0, delaySeconds) * 20L;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (!p.isOnline()) {
                    return;
                }
                if (!cfg.getBoolean("reward.enabled", true)) {
                    return;
                }
                String cmdTemplate = cfg.getString("reward.command", "");
                if (!cmdTemplate.isEmpty()) {
                    String cmdToRun = cmdTemplate.replace("%player%", p.getName());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmdToRun);
                }
                String msg = cfg.getString("messages.rewarded", "&aPay-day for keeping informed. Good work!");
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
                if (cfg.getBoolean("sound.enabled", true)) {
                    String soundName = cfg.getString("sound.name", "ENTITY_PLAYER_LEVELUP");
                    float volume = (float)cfg.getDouble("sound.volume", 0.6);
                    float pitch = (float)cfg.getDouble("sound.pitch", 1.2);
                    try {
                        p.playSound(p.getLocation(), Sound.valueOf((String)soundName), volume, pitch);
                    }
                    catch (IllegalArgumentException ex) {
                        this.plugin.getLogger().warning("Invalid sound in config.yml: " + soundName);
                    }
                }
            }, delayTicks);
        }
        return true;
    }
}

