/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class NewsManager {
    private final Plugin plugin;
    private List<String> cachedNews = Collections.emptyList();
    private List<String> cachedTestNews = Collections.emptyList();

    public NewsManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void loadAll() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.cachedNews = this.loadFileLines(new File(this.plugin.getDataFolder(), "news.yml"));
        this.cachedTestNews = this.loadFileLines(new File(this.plugin.getDataFolder(), "testnews.yml"));
    }

    public void reload() {
        this.loadAll();
    }

    public boolean hasNews() {
        return !this.cachedNews.isEmpty();
    }

    public boolean hasTestNews() {
        return !this.cachedTestNews.isEmpty();
    }

    public List<String> getNews() {
        return this.cachedNews;
    }

    public List<String> getTestNews() {
        return this.cachedTestNews;
    }

    private List<String> loadFileLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!file.exists()) {
            return Collections.unmodifiableList(lines);
        }
        YamlConfiguration yml = new YamlConfiguration();
        try {
            yml.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getLogger().warning("Failed to load " + file.getName() + ": " + e.getMessage());
            return Collections.unmodifiableList(lines);
        }
        if (yml.contains("lines")) {
            for (String s : yml.getStringList("lines")) {
                lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            }
        } else if (yml.contains("text")) {
            String text = yml.getString("text", "");
            for (String s : text.split("\\r?\\n")) {
                lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            }
        }
        while (!lines.isEmpty() && this.isBlankAfterStrip((String)lines.get(lines.size() - 1))) {
            lines.remove(lines.size() - 1);
        }
        return Collections.unmodifiableList(lines);
    }

    private boolean isBlankAfterStrip(String s) {
        if (s == null) {
            return true;
        }
        String stripped = ChatColor.stripColor((String)s);
        return stripped == null || stripped.trim().isEmpty();
    }
}

