/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class NewsTab
implements TabCompleter {
    private static final List<String> SUBS = Arrays.asList("test", "reset", "list", "reload", "help");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String prefix = args[0].toLowerCase(Locale.ROOT);
            return SUBS.stream().filter(s -> s.startsWith(prefix)).filter(s -> this.canSee(sender, (String)s)).collect(Collectors.toList());
        }
        return null;
    }

    private boolean canSee(CommandSender sender, String sub) {
        if (sender.isOp()) {
            return true;
        }
        switch (sub) {
            case "test": {
                return sender.hasPermission("shantekmc.servernews.test");
            }
            case "reset": {
                return sender.hasPermission("shantekmc.servernews.reset");
            }
            case "list": {
                return sender.hasPermission("shantekmc.servernews.list");
            }
            case "reload": {
                return sender.hasPermission("shantekmc.servernews.reload");
            }
            case "help": {
                return true;
            }
        }
        return true;
    }
}

