/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ReadStore {
    private final Plugin plugin;
    private final File file;
    private final Set<UUID> readers = new HashSet<UUID>();

    public ReadStore(Plugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "data.yml");
    }

    public void load() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.readers.clear();
        if (!this.file.exists()) {
            this.save();
            return;
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.file);
        List list = cfg.getStringList("readers");
        for (String s : list) {
            try {
                this.readers.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void save() {
        YamlConfiguration cfg = new YamlConfiguration();
        ArrayList<String> list = new ArrayList<String>(this.readers.size());
        for (UUID id : this.readers) {
            list.add(id.toString());
        }
        cfg.set("readers", list);
        try {
            cfg.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save data.yml: " + e.getMessage());
        }
    }

    public boolean hasRead(UUID uuid) {
        return this.readers.contains(uuid);
    }

    public void markRead(UUID uuid) {
        if (this.readers.add(uuid)) {
            this.save();
        }
    }

    public int reset() {
        int cleared = this.readers.size();
        this.readers.clear();
        this.save();
        return cleared;
    }

    public int size() {
        return this.readers.size();
    }

    public Set<UUID> all() {
        return Collections.unmodifiableSet(this.readers);
    }
}

