/*
 * Decompiled with CFR 0.152.
 */
package com.ShantekMC;

import com.ShantekMC.JoinListener;
import com.ShantekMC.NewsCommand;
import com.ShantekMC.NewsManager;
import com.ShantekMC.NewsTab;
import com.ShantekMC.ReadStore;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerNews
extends JavaPlugin {
    private static ServerNews instance;
    private NewsManager newsManager;
    private ReadStore readStore;

    public static ServerNews getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.extractDefault("news.yml");
        this.extractDefault("testnews.yml");
        this.newsManager = new NewsManager((Plugin)this);
        this.readStore = new ReadStore((Plugin)this);
        this.newsManager.loadAll();
        this.readStore.load();
        PluginCommand newsCmd = this.getCommand("news");
        if (newsCmd != null) {
            NewsCommand exec = new NewsCommand(this);
            newsCmd.setExecutor((CommandExecutor)exec);
            newsCmd.setTabCompleter((TabCompleter)new NewsTab());
        } else {
            this.getLogger().severe("Command 'news' is missing from plugin.yml!");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getLogger().info("ServerNews enabled.");
    }

    private void extractDefault(String path) {
        try {
            if (this.getResource(path) != null) {
                this.saveResource(path, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.readStore.save();
        this.getLogger().info("ServerNews disabled.");
    }

    public NewsManager getNewsManager() {
        return this.newsManager;
    }

    public ReadStore getReadStore() {
        return this.readStore;
    }
}

