/*
 * Decompiled with CFR 0.152.
 */
package net.wisecase2.stutterfix.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import net.wisecase2.stutterfix.StutterFix;

public class ThreadConfig {
    public int mainWorkerExecutorCount;
    public int mainWorkerExecutorPriorityCut;
    public int renderThreadPriority;
    public int serverThreadPriority;
    public boolean renderRemoveYield;
    public boolean hideGui;
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public ThreadConfig() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.mainWorkerExecutorCount = StutterFix.getDefaultStutterFixMainWorkerExecutorCount();
        this.mainWorkerExecutorPriorityCut = this.mainWorkerExecutorCount / 2;
        this.renderThreadPriority = availableProcessors > 4 ? 10 : 5;
        this.serverThreadPriority = availableProcessors > 4 ? 8 : 5;
        this.renderRemoveYield = false;
        this.hideGui = false;
    }

    public void validateConfig() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.mainWorkerExecutorCount = class_3532.method_15340((int)this.mainWorkerExecutorCount, (int)1, (int)availableProcessors);
        this.mainWorkerExecutorPriorityCut = class_3532.method_15340((int)this.mainWorkerExecutorPriorityCut, (int)0, (int)availableProcessors);
        this.renderThreadPriority = class_3532.method_15340((int)this.renderThreadPriority, (int)1, (int)10);
        this.serverThreadPriority = class_3532.method_15340((int)this.serverThreadPriority, (int)1, (int)10);
    }

    public static ThreadConfig readConfig(String name) {
        ThreadConfig config;
        Path path;
        block8: {
            path = FabricLoader.getInstance().getConfigDir().resolve(name);
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (ThreadConfig)GSON.fromJson((Reader)reader, ThreadConfig.class);
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new ThreadConfig();
        }
        config.configPath = path;
        config.validateConfig();
        return config;
    }

    public void saveConfig() {
        try {
            Path dir = this.configPath.getParent();
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            Path tempPath = this.configPath.resolveSibling(String.valueOf(this.configPath.getFileName()) + ".tmp");
            Files.writeString(tempPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
            Files.move(tempPath, this.configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't save config file", e);
        }
    }
}

