/*
 * Decompiled with CFR 0.152.
 */
package com.heldheld.closeonmove.config;

import com.heldheld.closeonmove.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.lwjgl.glfw.GLFW;

public class ConfigMenu
extends class_437 {
    private final class_437 parent;
    private final Config config;
    private final class_8132 layout = new class_8132((class_437)this);
    private final int[] tempKeys = new int[10];
    private int waitingForKeySlot = -1;
    private boolean waitingForRelease = false;
    private final boolean[] keyPressed = new boolean[350];
    private final boolean[] mousePressed = new boolean[8];
    private final class_4185[] keybindButtons = new class_4185[10];

    public ConfigMenu(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"CloseOnMove Settings"));
        this.parent = parent;
        this.config = Config.getInstance();
        this.initializeTempKeys();
    }

    private void initializeTempKeys() {
        for (int i = 0; i < 10; ++i) {
            this.tempKeys[i] = -1;
        }
        List<Integer> currentKeys = this.config.getCloseKeys();
        for (int i = 0; i < Math.min(currentKeys.size(), 10); ++i) {
            this.tempKeys[i] = currentKeys.get(i);
        }
        if (currentKeys.isEmpty()) {
            this.tempKeys[0] = 87;
            this.tempKeys[1] = 65;
            this.tempKeys[2] = 83;
            this.tempKeys[3] = 68;
            this.tempKeys[4] = 32;
        }
    }

    protected void method_25426() {
        this.layout.method_57726(this.field_22785, this.field_22793);
        class_7845 gridWidget = (class_7845)this.layout.method_48999((class_8021)new class_7845());
        gridWidget.method_46458().method_46477(8).method_46479(4);
        class_7845.class_7939 adder = gridWidget.method_47610(2);
        for (int i = 0; i < 10; ++i) {
            int slot = i;
            this.keybindButtons[i] = class_4185.method_46430((class_2561)this.getKeyButtonText(slot), button -> {
                if (this.waitingForKeySlot == -1) {
                    this.startKeyBinding(slot);
                }
            }).method_46432(145).method_46431();
            adder.method_47612((class_8021)this.keybindButtons[i]);
        }
        class_7845 bottomButtons = (class_7845)this.layout.method_48996((class_8021)new class_7845());
        bottomButtons.method_46458().method_46477(8);
        class_7845.class_7939 bottomAdder = bottomButtons.method_47610(3);
        bottomAdder.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.onCancelClick()).method_46432(80).method_46431());
        bottomAdder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save & Quit"), button -> this.onSaveClick()).method_46432(80).method_46431());
        bottomAdder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> this.onResetClick()).method_46432(80).method_46431());
        this.layout.method_48222();
        class_7843.method_46443((class_8021)this.layout, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.5f, (float)0.25f);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    private class_2561 getKeyButtonText(int slot) {
        String keyName = this.tempKeys[slot] == -1 ? "Not Bound" : this.config.getKeyName(this.tempKeys[slot]);
        if (this.waitingForKeySlot == slot) {
            return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"> ").method_27694(style -> style.method_10977(class_124.field_1054))).method_10852((class_2561)class_2561.method_43470((String)keyName).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)" <").method_27694(style -> style.method_10977(class_124.field_1054)));
        }
        return class_2561.method_43470((String)keyName);
    }

    private void startKeyBinding(int slot) {
        if (this.waitingForKeySlot != -1) {
            return;
        }
        this.waitingForKeySlot = slot;
        this.waitingForRelease = true;
        this.mousePressed[0] = true;
        this.refreshKeybindButtons();
    }

    private void refreshKeybindButtons() {
        for (int i = 0; i < 10; ++i) {
            if (this.keybindButtons[i] == null) continue;
            this.keybindButtons[i].method_25355(this.getKeyButtonText(i));
        }
    }

    private void handleKeyInput() {
        boolean isPressed;
        if (this.waitingForKeySlot == -1 || this.field_22787 == null || this.field_22787.method_22683() == null) {
            return;
        }
        long handle = this.field_22787.method_22683().method_4490();
        if (this.waitingForRelease && GLFW.glfwGetMouseButton((long)handle, (int)0) != 1) {
            this.waitingForRelease = false;
        }
        for (int key = 32; key <= 348; ++key) {
            boolean bl = isPressed = GLFW.glfwGetKey((long)handle, (int)key) == 1;
            if (isPressed && !this.keyPressed[key]) {
                this.keyPressed[key] = true;
                if (key == 256) {
                    this.tempKeys[this.waitingForKeySlot] = -1;
                    this.waitingForKeySlot = -1;
                    this.waitingForRelease = false;
                    this.refreshKeybindButtons();
                    return;
                }
                this.tempKeys[this.waitingForKeySlot] = key;
                this.waitingForKeySlot = -1;
                this.waitingForRelease = false;
                this.refreshKeybindButtons();
                return;
            }
            if (isPressed) continue;
            this.keyPressed[key] = false;
        }
        for (int button = 0; button < 8; ++button) {
            boolean bl = isPressed = GLFW.glfwGetMouseButton((long)handle, (int)button) == 1;
            if (isPressed && !this.mousePressed[button]) {
                this.mousePressed[button] = true;
                this.tempKeys[this.waitingForKeySlot] = button;
                this.waitingForKeySlot = -1;
                this.refreshKeybindButtons();
                return;
            }
            if (isPressed) continue;
            this.mousePressed[button] = false;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.handleKeyInput();
        class_5250 subtitleText = class_2561.method_43470((String)"Keys (or mouse buttons) that exit the GUI's:");
        int subtitleX = this.field_22789 / 2;
        int subtitleY = 25;
        context.method_27534(this.field_22793, (class_2561)subtitleText, subtitleX, subtitleY, -5592406);
    }

    private void onCancelClick() {
        this.waitingForKeySlot = -1;
        this.method_25419();
    }

    private void onSaveClick() {
        ArrayList<Integer> keysToSave = new ArrayList<Integer>();
        for (int key : this.tempKeys) {
            if (key == -1) continue;
            keysToSave.add(key);
        }
        this.config.setCloseKeys(keysToSave);
        this.method_25419();
    }

    private void onResetClick() {
        for (int i = 0; i < 10; ++i) {
            this.tempKeys[i] = -1;
        }
        this.tempKeys[0] = 87;
        this.tempKeys[1] = 65;
        this.tempKeys[2] = 83;
        this.tempKeys[3] = 68;
        this.tempKeys[4] = 32;
        this.waitingForKeySlot = -1;
        this.refreshKeybindButtons();
    }

    public boolean method_25422() {
        return this.waitingForKeySlot == -1;
    }

    public void method_25419() {
        this.waitingForKeySlot = -1;
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

