/*
 * Decompiled with CFR 0.152.
 */
package com.heldheld.closeonmove;

import com.heldheld.closeonmove.config.Config;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_465;
import org.lwjgl.glfw.GLFW;

public class CloseOnMoveClient
implements ClientModInitializer {
    private final class_310 client = class_310.method_1551();
    private Config config;
    private Map<Integer, Boolean> keyStates = new HashMap<Integer, Boolean>();

    public void onInitializeClient() {
        this.config = Config.getInstance();
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private boolean isClosableScreen(class_437 screen) {
        String screenClassName = screen.getClass().getSimpleName();
        String packageName = screen.getClass().getPackage().getName();
        if (screen instanceof class_465) {
            return true;
        }
        if (screen instanceof class_457) {
            return true;
        }
        if (screen instanceof class_3872) {
            return true;
        }
        return packageName.contains("ingame");
    }

    private void onClientTick(class_310 client) {
        class_437 currentScreen = client.field_1755;
        if (currentScreen == null) {
            this.keyStates.clear();
            return;
        }
        if (client.field_1687 == null) {
            this.keyStates.clear();
            return;
        }
        if (!this.isClosableScreen(currentScreen)) {
            this.keyStates.clear();
            return;
        }
        List<Integer> closeKeys = this.config.getCloseKeys();
        boolean anyKeyPressed = false;
        for (int keyCode : closeKeys) {
            if (!this.isInputPressedOnce(keyCode)) continue;
            anyKeyPressed = true;
            break;
        }
        if (anyKeyPressed && !this.isTextFieldFocused(currentScreen)) {
            currentScreen.method_25419();
        }
    }

    private boolean isInputPressedOnce(int keyCode) {
        boolean isCurrentlyPressed = this.isMouseButton(keyCode) ? GLFW.glfwGetMouseButton((long)this.client.method_22683().method_4490(), (int)keyCode) == 1 : class_3675.method_15987((class_1041)this.client.method_22683(), (int)keyCode);
        boolean wasInputPreviouslyPressed = this.keyStates.getOrDefault(keyCode, false);
        if (isCurrentlyPressed && !wasInputPreviouslyPressed) {
            this.keyStates.put(keyCode, true);
            return true;
        }
        if (!isCurrentlyPressed) {
            this.keyStates.put(keyCode, false);
        }
        return false;
    }

    private boolean isMouseButton(int keyCode) {
        return keyCode >= 0 && keyCode <= 7;
    }

    private boolean isTextFieldFocused(class_437 screen) {
        if (this.hasAnyFocusedTextField(screen)) {
            return true;
        }
        String screenClassName = screen.getClass().getSimpleName().toLowerCase();
        return screenClassName.contains("edit");
    }

    private boolean hasAnyFocusedTextField(class_437 screen) {
        return this.checkChildrenForFocusedTextField(screen.method_25396());
    }

    private boolean checkChildrenForFocusedTextField(Iterable<?> children) {
        for (Object child : children) {
            class_342 textField;
            if (child instanceof class_342 && (textField = (class_342)child).method_25370()) {
                return true;
            }
            try {
                Iterable nestedChildren;
                Field childrenField = child.getClass().getDeclaredField("children");
                childrenField.setAccessible(true);
                Object childrenObj = childrenField.get(child);
                if (childrenObj instanceof Iterable && this.checkChildrenForFocusedTextField(nestedChildren = (Iterable)childrenObj)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.hasTextFieldInFields(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTextFieldInFields(Object obj) {
        for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    class_342 textField;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value instanceof class_342 && (textField = (class_342)value).method_25370()) {
                        return true;
                    }
                    if (!(value instanceof Iterable)) continue;
                    Iterable iterable = (Iterable)value;
                    for (Object item : iterable) {
                        class_342 textField2;
                        if (!(item instanceof class_342) || !(textField2 = (class_342)item).method_25370()) continue;
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

