/*
 * Decompiled with CFR 0.152.
 */
package com.heldheld.closeonmove.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final String CONFIG_FILE_NAME = "closeonmove.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Config INSTANCE;
    private List<Integer> CloseKeys = Arrays.asList(87, 65, 83, 68, 32);
    private static final Map<Integer, String> KEY_NAMES;
    private static final Map<String, Integer> NAME_TO_KEY;

    private static void addKeyMapping(int keyCode, String name) {
        KEY_NAMES.put(keyCode, name);
        NAME_TO_KEY.put(name, keyCode);
        NAME_TO_KEY.put(name.toUpperCase(), keyCode);
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = Config.load();
        }
        return INSTANCE;
    }

    public List<Integer> getCloseKeys() {
        return new ArrayList<Integer>(this.CloseKeys);
    }

    public void setCloseKeys(List<Integer> keys) {
        this.CloseKeys = new ArrayList<Integer>(keys);
        this.save();
    }

    public void addCloseKey(int keyCode) {
        if (!this.CloseKeys.contains(keyCode)) {
            this.CloseKeys.add(keyCode);
            this.save();
        }
    }

    public void removeCloseKey(int keyCode) {
        this.CloseKeys.remove((Object)keyCode);
        this.save();
    }

    public boolean isCloseKey(int keyCode) {
        return this.CloseKeys.contains(keyCode);
    }

    public String getKeyName(int keyCode) {
        return KEY_NAMES.getOrDefault(keyCode, "KEY_" + keyCode);
    }

    public Integer getKeyCode(String name) {
        return NAME_TO_KEY.get(name);
    }

    public Set<String> getAllKeyNames() {
        return new HashSet<String>(KEY_NAMES.values());
    }

    public static Config load() {
        Config config;
        File configFile = Config.getConfigFile();
        if (!configFile.exists()) {
            Config config2 = new Config();
            config2.save();
            return config2;
        }
        FileReader reader = new FileReader(configFile);
        try {
            Type listType = new TypeToken<List<String>>(){}.getType();
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            Config config3 = new Config();
            if (data != null && data.CloseKeys != null) {
                ArrayList<Integer> keys = new ArrayList<Integer>();
                for (String keyName : data.CloseKeys) {
                    Integer keyCode = config3.getKeyCode(keyName);
                    if (keyCode == null) continue;
                    keys.add(keyCode);
                }
                if (!keys.isEmpty()) {
                    config3.CloseKeys = keys;
                }
            }
            config = config3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                return new Config();
            }
        }
        reader.close();
        return config;
    }

    public void save() {
        File configFile = Config.getConfigFile();
        try {
            configFile.getParentFile().mkdirs();
            ConfigData data = new ConfigData();
            data.CloseKeys = new ArrayList<String>();
            for (int keyCode : this.CloseKeys) {
                data.CloseKeys.add(this.getKeyName(keyCode));
            }
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE_NAME);
    }

    static {
        KEY_NAMES = new HashMap<Integer, String>();
        NAME_TO_KEY = new HashMap<String, Integer>();
        Config.addKeyMapping(65, "A");
        Config.addKeyMapping(66, "B");
        Config.addKeyMapping(67, "C");
        Config.addKeyMapping(68, "D");
        Config.addKeyMapping(69, "E");
        Config.addKeyMapping(70, "F");
        Config.addKeyMapping(71, "G");
        Config.addKeyMapping(72, "H");
        Config.addKeyMapping(73, "I");
        Config.addKeyMapping(74, "J");
        Config.addKeyMapping(75, "K");
        Config.addKeyMapping(76, "L");
        Config.addKeyMapping(77, "M");
        Config.addKeyMapping(78, "N");
        Config.addKeyMapping(79, "O");
        Config.addKeyMapping(80, "P");
        Config.addKeyMapping(81, "Q");
        Config.addKeyMapping(82, "R");
        Config.addKeyMapping(83, "S");
        Config.addKeyMapping(84, "T");
        Config.addKeyMapping(85, "U");
        Config.addKeyMapping(86, "V");
        Config.addKeyMapping(87, "W");
        Config.addKeyMapping(88, "X");
        Config.addKeyMapping(89, "Y");
        Config.addKeyMapping(90, "Z");
        Config.addKeyMapping(48, "0");
        Config.addKeyMapping(49, "1");
        Config.addKeyMapping(50, "2");
        Config.addKeyMapping(51, "3");
        Config.addKeyMapping(52, "4");
        Config.addKeyMapping(53, "5");
        Config.addKeyMapping(54, "6");
        Config.addKeyMapping(55, "7");
        Config.addKeyMapping(56, "8");
        Config.addKeyMapping(57, "9");
        Config.addKeyMapping(290, "F1");
        Config.addKeyMapping(291, "F2");
        Config.addKeyMapping(292, "F3");
        Config.addKeyMapping(293, "F4");
        Config.addKeyMapping(294, "F5");
        Config.addKeyMapping(295, "F6");
        Config.addKeyMapping(296, "F7");
        Config.addKeyMapping(297, "F8");
        Config.addKeyMapping(298, "F9");
        Config.addKeyMapping(299, "F10");
        Config.addKeyMapping(300, "F11");
        Config.addKeyMapping(301, "F12");
        Config.addKeyMapping(302, "F13");
        Config.addKeyMapping(303, "F14");
        Config.addKeyMapping(304, "F15");
        Config.addKeyMapping(305, "F16");
        Config.addKeyMapping(306, "F17");
        Config.addKeyMapping(307, "F18");
        Config.addKeyMapping(308, "F19");
        Config.addKeyMapping(309, "F20");
        Config.addKeyMapping(310, "F21");
        Config.addKeyMapping(311, "F22");
        Config.addKeyMapping(312, "F23");
        Config.addKeyMapping(313, "F24");
        Config.addKeyMapping(314, "F25");
        Config.addKeyMapping(265, "Up");
        Config.addKeyMapping(264, "Down");
        Config.addKeyMapping(263, "Left");
        Config.addKeyMapping(262, "Right");
        Config.addKeyMapping(32, "Space");
        Config.addKeyMapping(257, "Enter");
        Config.addKeyMapping(258, "Tab");
        Config.addKeyMapping(259, "Backspace");
        Config.addKeyMapping(261, "Delete");
        Config.addKeyMapping(260, "Insert");
        Config.addKeyMapping(268, "Home");
        Config.addKeyMapping(269, "End");
        Config.addKeyMapping(266, "Page Up");
        Config.addKeyMapping(267, "Page Down");
        Config.addKeyMapping(340, "Left Shift");
        Config.addKeyMapping(344, "Right Shift");
        Config.addKeyMapping(341, "Left Control");
        Config.addKeyMapping(345, "Right Control");
        Config.addKeyMapping(342, "Left Alt");
        Config.addKeyMapping(346, "Right Alt");
        Config.addKeyMapping(343, "Left Win");
        Config.addKeyMapping(347, "Right Win");
        Config.addKeyMapping(348, "Menu");
        Config.addKeyMapping(280, "Caps Lock");
        Config.addKeyMapping(281, "Scroll Lock");
        Config.addKeyMapping(282, "Num Lock");
        Config.addKeyMapping(320, "Keypad 0");
        Config.addKeyMapping(321, "Keypad 1");
        Config.addKeyMapping(322, "Keypad 2");
        Config.addKeyMapping(323, "Keypad 3");
        Config.addKeyMapping(324, "Keypad 4");
        Config.addKeyMapping(325, "Keypad 5");
        Config.addKeyMapping(326, "Keypad 6");
        Config.addKeyMapping(327, "Keypad 7");
        Config.addKeyMapping(328, "Keypad 8");
        Config.addKeyMapping(329, "Keypad 9");
        Config.addKeyMapping(330, "Keypad .");
        Config.addKeyMapping(331, "Keypad /");
        Config.addKeyMapping(332, "Keypad *");
        Config.addKeyMapping(333, "Keypad -");
        Config.addKeyMapping(334, "Keypad +");
        Config.addKeyMapping(335, "Keypad Enter");
        Config.addKeyMapping(336, "Keypad =");
        Config.addKeyMapping(59, ";");
        Config.addKeyMapping(61, "=");
        Config.addKeyMapping(44, ",");
        Config.addKeyMapping(45, "-");
        Config.addKeyMapping(46, ".");
        Config.addKeyMapping(47, "/");
        Config.addKeyMapping(96, "`");
        Config.addKeyMapping(91, "[");
        Config.addKeyMapping(92, "\\");
        Config.addKeyMapping(93, "]");
        Config.addKeyMapping(39, "'");
        Config.addKeyMapping(283, "Print Screen");
        Config.addKeyMapping(284, "Pause");
        Config.addKeyMapping(161, "World 1");
        Config.addKeyMapping(162, "World 2");
        Config.addKeyMapping(0, "Left Button");
        Config.addKeyMapping(1, "Right Button");
        Config.addKeyMapping(2, "Middle Button");
        Config.addKeyMapping(3, "Back Button");
        Config.addKeyMapping(4, "Forward Button");
        Config.addKeyMapping(5, "Button 6");
        Config.addKeyMapping(6, "Button 7");
        Config.addKeyMapping(7, "Button 8");
    }

    private static class ConfigData {
        public List<String> CloseKeys;

        private ConfigData() {
        }
    }
}

