/*
 * Decompiled with CFR 0.152.
 */
package com.mcwholidays.kikoz.objects.christmas;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Garland
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    private static final VoxelShape SIDE_S = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_E = Shapes.or((VoxelShape)Block.box((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_W = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_N = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_N = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_E = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_S = Shapes.or((VoxelShape)Block.box((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_W = Shapes.or((VoxelShape)Block.box((double)12.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape CORNER_N = Shapes.or((VoxelShape)SIDE_N, (VoxelShape)SIDE_E);
    protected static final VoxelShape CORNER_E = Shapes.or((VoxelShape)SIDE_E, (VoxelShape)SIDE_S);
    protected static final VoxelShape CORNER_S = Shapes.or((VoxelShape)SIDE_S, (VoxelShape)SIDE_W);
    protected static final VoxelShape CORNER_W = Shapes.or((VoxelShape)SIDE_W, (VoxelShape)SIDE_N);

    public Garland(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue(SHAPE, (Comparable)Garland.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.updateShape(stateIn, worldIn, ticker, currentPos, facing, facingPos, facingState, random);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue(FACING)) {
            case WEST: {
                switch ((StairsShape)state.getValue(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_W;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_E;
                    }
                    case OUTER_LEFT: {
                        return OUTER_N;
                    }
                    case INNER_LEFT: {
                        return CORNER_S;
                    }
                }
                return CORNER_W;
            }
            case EAST: {
                switch ((StairsShape)state.getValue(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_E;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_W;
                    }
                    case OUTER_LEFT: {
                        return OUTER_S;
                    }
                    case INNER_LEFT: {
                        return CORNER_N;
                    }
                }
                return CORNER_E;
            }
            case SOUTH: {
                switch ((StairsShape)state.getValue(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_S;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_N;
                    }
                    case OUTER_LEFT: {
                        return OUTER_W;
                    }
                    case INNER_LEFT: {
                        return CORNER_E;
                    }
                }
                return CORNER_S;
            }
            case NORTH: {
                switch ((StairsShape)state.getValue(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_N;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_S;
                    }
                    case OUTER_LEFT: {
                        return OUTER_E;
                    }
                    case INNER_LEFT: {
                        return CORNER_W;
                    }
                }
                return CORNER_N;
            }
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Direction horizontalDirection = context.getHorizontalDirection();
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)horizontalDirection);
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)Garland.getShapeProperty(blockstate, (BlockGetter)context.getLevel(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.getValue(FACING);
        BlockState blockstate = worldIn.getBlockState(pos.relative(direction));
        if (Garland.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.getValue(FACING)).getAxis() != direction.getAxis()) {
            return direction1 == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (Garland.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.getValue(FACING)).getAxis() != direction.getAxis()) {
            return direction2 == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof Garland;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue(FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
        }
        return super.mirror(state, mirrorIn);
    }

    private StairsShape getMirroredShape(StairsShape shape) {
        switch (shape) {
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
        }
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE});
    }
}

