/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.injection.mixin.features.item.data_fix;

import com.viaversion.viafabricplus.api.events.LoadingCycleCallback;
import com.viaversion.viafabricplus.base.Events;
import com.viaversion.viafabricplus.protocoltranslator.impl.ViaFabricPlusMappingDataLoader;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.ToolProperties;
import com.viaversion.viaversion.api.minecraft.item.data.ToolRule;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundPacket1_20_3;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.Protocol1_20_3To1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundPacket1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.rewriter.BlockItemPacketRewriter1_20_5;
import com.viaversion.viaversion.rewriter.ItemRewriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockItemPacketRewriter1_20_5.class}, remap=false)
public abstract class MixinBlockItemPacketRewriter1_20_5
extends ItemRewriter<ClientboundPacket1_20_3, ServerboundPacket1_20_5, Protocol1_20_3To1_20_5> {
    @Unique
    private final Set<String> viaFabricPlus$foodItems_b1_7_3 = new HashSet<String>();
    @Unique
    private final Map<String, Integer> viaFabricPlus$armorMaxDamage_b1_8_1 = new HashMap<String, Integer>();
    @Unique
    private final Map<ProtocolVersion, Map<String, ToolProperties>> viaFabricPlus$toolDataChanges = new LinkedHashMap<ProtocolVersion, Map<String, ToolProperties>>();

    public MixinBlockItemPacketRewriter1_20_5(Protocol1_20_3To1_20_5 protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super((Protocol)protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType);
    }

    @Inject(method={"<init>(Lcom/viaversion/viaversion/protocols/v1_20_3to1_20_5/Protocol1_20_3To1_20_5;)V"}, at={@At(value="RETURN")})
    private void loadItemMappings(Protocol1_20_3To1_20_5 protocol, CallbackInfo ci) {
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:apple");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:mushroom_stew");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:bread");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:porkchop");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:cooked_porkchop");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:golden_apple");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:cod");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:cooked_cod");
        this.viaFabricPlus$foodItems_b1_7_3.add("minecraft:cookie");
        JsonObject armorMaxDamages = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("armor-damages-b1.8.1.json");
        for (Map.Entry entry : armorMaxDamages.entrySet()) {
            this.viaFabricPlus$armorMaxDamage_b1_8_1.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
        }
        Events.LOADING_CYCLE.register(cycle -> {
            if (cycle != LoadingCycleCallback.LoadingCycle.POST_VIAVERSION_LOAD) {
                return;
            }
            JsonObject itemToolComponents = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("item-tool-components.json");
            for (Map.Entry entry : itemToolComponents.entrySet()) {
                ProtocolVersion version = ProtocolVersion.getClosest((String)((String)entry.getKey()));
                if (version == null) {
                    throw new IllegalStateException("Unknown protocol version: " + (String)entry.getKey());
                }
                HashMap<String, ToolProperties> toolProperties = new HashMap<String, ToolProperties>();
                JsonArray toolComponents = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement toolComponent : toolComponents) {
                    JsonObject toolComponentObject = toolComponent.getAsJsonObject();
                    String item = toolComponentObject.get("item").getAsString();
                    float defaultMiningSpeed = toolComponentObject.get("default_mining_speed").getAsFloat();
                    int damagePerBlock = toolComponentObject.get("damage_per_block").getAsInt();
                    int[] suitableFor = this.viaFabricPlus$blockJsonArrayToIds(version, toolComponentObject.getAsJsonArray("suitable_for"));
                    ArrayList<ToolRule> toolRules = new ArrayList<ToolRule>();
                    JsonArray miningSpeeds = toolComponentObject.getAsJsonArray("mining_speeds");
                    for (JsonElement miningSpeed : miningSpeeds) {
                        JsonObject miningSpeedObject = miningSpeed.getAsJsonObject();
                        int[] blocks = this.viaFabricPlus$blockJsonArrayToIds(version, miningSpeedObject.getAsJsonArray("blocks"));
                        float speed = miningSpeedObject.get("speed").getAsFloat();
                        toolRules.add(new ToolRule(HolderSet.of((int[])blocks), Float.valueOf(speed), null));
                    }
                    if (suitableFor.length > 0) {
                        toolRules.add(new ToolRule(HolderSet.of((int[])suitableFor), null, Boolean.valueOf(true)));
                    }
                    toolProperties.put(item, new ToolProperties(toolRules.toArray(new ToolRule[0]), defaultMiningSpeed, damagePerBlock));
                }
                this.viaFabricPlus$toolDataChanges.put(version, toolProperties);
            }
        });
    }

    @Inject(method={"appendItemDataFixComponents(Lcom/viaversion/viaversion/api/connection/UserConnection;Lcom/viaversion/viaversion/api/minecraft/item/Item;)V"}, at={@At(value="RETURN")})
    private void appendItemDataFixComponents(UserConnection user, Item item, CallbackInfo ci) {
        StructuredDataContainer data = item.dataContainer();
        String identifier = ((Protocol1_20_3To1_20_5)this.protocol).getMappingData().getFullItemMappings().identifier(item.identifier());
        if (user.getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.b1_8tob1_8_1) && this.viaFabricPlus$armorMaxDamage_b1_8_1.containsKey(identifier)) {
            data.set(StructuredDataKey.MAX_DAMAGE, (Object)this.viaFabricPlus$armorMaxDamage_b1_8_1.get(identifier));
        }
        if (user.getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(LegacyProtocolVersion.b1_7tob1_7_3) && this.viaFabricPlus$foodItems_b1_7_3.contains(identifier)) {
            data.set(StructuredDataKey.MAX_STACK_SIZE, (Object)1);
            data.setEmpty(StructuredDataKey.FOOD1_20_5);
        }
        for (Map.Entry<ProtocolVersion, Map<String, ToolProperties>> entry : this.viaFabricPlus$toolDataChanges.entrySet()) {
            ToolProperties toolProperties;
            if (!user.getProtocolInfo().serverProtocolVersion().olderThanOrEqualTo(entry.getKey()) || (toolProperties = entry.getValue().get(identifier)) == null) continue;
            data.set(StructuredDataKey.TOOL1_20_5, (Object)toolProperties);
            break;
        }
    }

    @Unique
    private int[] viaFabricPlus$blockJsonArrayToIds(ProtocolVersion protocolVersion, JsonArray jsonArray) {
        IntOpenHashSet ids = new IntOpenHashSet();
        for (JsonElement element : jsonArray) {
            String name = element.getAsString();
            if (name.startsWith("#")) {
                String material = name.substring(1);
                block1: for (Map.Entry<String, Map<ProtocolVersion, String>> entry : ViaFabricPlusMappingDataLoader.BLOCK_MATERIALS.entrySet()) {
                    for (Map.Entry<ProtocolVersion, String> materialEntry : entry.getValue().entrySet()) {
                        if (!protocolVersion.olderThanOrEqualTo(materialEntry.getKey()) || !materialEntry.getValue().equals(material)) continue;
                        ids.add(((Protocol1_20_3To1_20_5)this.protocol).getMappingData().blockId(entry.getKey()));
                        continue block1;
                    }
                }
                continue;
            }
            if (name.startsWith("-")) {
                ids.remove(((Protocol1_20_3To1_20_5)this.protocol).getMappingData().blockId(name.substring(1)));
                continue;
            }
            ids.add(((Protocol1_20_3To1_20_5)this.protocol).getMappingData().blockId(name));
        }
        return ids.toIntArray();
    }
}

