/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.screen.impl.classic4j;

import com.viaversion.viafabricplus.screen.VFPList;
import com.viaversion.viafabricplus.screen.VFPListEntry;
import com.viaversion.viafabricplus.screen.VFPScreen;
import com.viaversion.viafabricplus.screen.impl.settings.TitleEntry;
import com.viaversion.viafabricplus.util.ConnectionUtil;
import de.florianmichael.classic4j.BetaCraftHandler;
import de.florianmichael.classic4j.model.betacraft.BCServerInfo;
import de.florianmichael.classic4j.model.betacraft.BCServerList;
import de.florianmichael.classic4j.model.betacraft.BCVersionCategory;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;

public final class BetaCraftScreen
extends VFPScreen {
    public static final BetaCraftScreen INSTANCE = new BetaCraftScreen();
    public static BCServerList SERVER_LIST;
    private static final String BETA_CRAFT_SERVER_LIST_URL = "https://betacraft.uk/serverlist/";

    private BetaCraftScreen() {
        super("BetaCraft", true);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (SERVER_LIST != null) {
            this.createView();
            return;
        }
        this.setupSubtitle((class_2561)class_2561.method_43471((String)"betacraft.viafabricplus.loading"));
        BetaCraftHandler.requestServerList(serverList -> {
            SERVER_LIST = serverList;
            this.createView();
        }, throwable -> BetaCraftScreen.showErrorScreen(INSTANCE.method_25440(), throwable, this));
    }

    private void createView() {
        this.setupSubtitle(class_2561.method_30163((String)BETA_CRAFT_SERVER_LIST_URL), class_407.method_49625((class_437)this, (String)BETA_CRAFT_SERVER_LIST_URL));
        Objects.requireNonNull(this.field_22793);
        int entryHeight = (9 + 2) * 3;
        this.method_37063((class_364)new SlotList(this.field_22787, this.field_22789, this.field_22790, 6 + entryHeight, -5, entryHeight));
        this.addRefreshButton(() -> {
            SERVER_LIST = null;
        });
    }

    @Override
    protected boolean subtitleCentered() {
        return SERVER_LIST == null;
    }

    public static class SlotList
    extends VFPList {
        private static double scrollAmount;

        public SlotList(class_310 minecraftClient, int width, int height, int top, int bottom, int entryHeight) {
            super(minecraftClient, width, height, top, bottom, entryHeight);
            if (SERVER_LIST == null) {
                return;
            }
            for (BCVersionCategory value : BCVersionCategory.values()) {
                List servers = SERVER_LIST.serversOfVersionCategory(value);
                if (servers.isEmpty()) continue;
                this.method_25321((class_350.class_351)new TitleEntry(class_2561.method_30163((String)value.name())));
                for (BCServerInfo server : servers) {
                    this.method_25321((class_350.class_351)new ServerSlot(server));
                }
            }
            this.initScrollY(scrollAmount);
        }

        public int method_25322() {
            return super.method_25322() + 140;
        }

        @Override
        protected void updateSlotAmount(double amount) {
            scrollAmount = amount;
        }
    }

    public static class ServerSlot
    extends VFPListEntry {
        private final BCServerInfo server;

        public ServerSlot(BCServerInfo server) {
            this.server = server;
        }

        public class_2561 method_37006() {
            return class_2561.method_30163((String)this.server.name());
        }

        @Override
        public void mappedMouseClicked(double mouseX, double mouseY, int button) {
            ConnectionUtil.connect(this.server.name(), this.server.socket());
            super.mappedMouseClicked(mouseX, mouseY, button);
        }

        @Override
        public void mappedRender(class_332 context, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            String string = this.server.name() + String.valueOf(class_124.field_1063) + " [" + this.server.gameVersion() + "]";
            int n = entryWidth / 2;
            int n2 = entryHeight / 2;
            Objects.requireNonNull(textRenderer);
            context.method_25300(textRenderer, string, n, n2 - 9 / 2, -1);
            if (this.server.onlineMode()) {
                context.method_27535(textRenderer, (class_2561)class_2561.method_43471((String)"base.viafabricplus.online_mode").method_27692(class_124.field_1060), 1, 1, -1);
            }
            String playerText = this.server.playerCount() + "/" + this.server.playerLimit();
            context.method_25303(textRenderer, playerText, entryWidth - textRenderer.method_1727(playerText) - 1, 1, -1);
        }
    }
}

