/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator.impl;

import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viaversion.api.data.MappingDataLoader;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public final class ViaFabricPlusMappingDataLoader
extends MappingDataLoader {
    public static final Map<String, Material> MATERIALS = new HashMap<String, Material>();
    public static final Map<String, Map<ProtocolVersion, String>> BLOCK_MATERIALS = new HashMap<String, Map<ProtocolVersion, String>>();
    public static final ViaFabricPlusMappingDataLoader INSTANCE = new ViaFabricPlusMappingDataLoader();

    private ViaFabricPlusMappingDataLoader() {
        super(ViaFabricPlusMappingDataLoader.class, "assets/viafabricplus/data/");
        JsonObject materialsData = this.loadData("materials-1.19.4.json");
        for (Map.Entry entry : materialsData.getAsJsonObject("materials").entrySet()) {
            JsonObject materialData = ((JsonElement)entry.getValue()).getAsJsonObject();
            MATERIALS.put((String)entry.getKey(), new Material(materialData.get("blocksMovement").getAsBoolean(), materialData.get("burnable").getAsBoolean(), materialData.get("liquid").getAsBoolean(), materialData.get("blocksLight").getAsBoolean(), materialData.get("replaceable").getAsBoolean(), materialData.get("solid").getAsBoolean()));
        }
        for (Map.Entry blockEntry : materialsData.getAsJsonObject("blocks").entrySet()) {
            HashMap<ProtocolVersion, String> blockMaterials = new HashMap<ProtocolVersion, String>();
            for (Map.Entry entry : ((JsonElement)blockEntry.getValue()).getAsJsonObject().entrySet()) {
                blockMaterials.put(ProtocolVersion.getClosest((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsString());
            }
            BLOCK_MATERIALS.put((String)blockEntry.getKey(), blockMaterials);
        }
    }

    public static String getBlockMaterial(class_2248 block) {
        return ViaFabricPlusMappingDataLoader.getBlockMaterial(block, ProtocolTranslator.getTargetVersion());
    }

    public static String getBlockMaterial(class_2248 block, ProtocolVersion version) {
        Map<ProtocolVersion, String> materials;
        if (version.newerThan(ProtocolVersion.v1_19_4)) {
            version = ProtocolVersion.v1_19_4;
        }
        if ((materials = BLOCK_MATERIALS.get(class_7923.field_41175.method_10221((Object)block).toString())) == null) {
            return null;
        }
        for (Map.Entry<ProtocolVersion, String> materialEntry : materials.entrySet()) {
            if (!version.olderThanOrEqualTo(materialEntry.getKey())) continue;
            return materialEntry.getValue();
        }
        return null;
    }

    public record Material(boolean blocksMovement, boolean burnable, boolean liquid, boolean blocksLight, boolean replaceable, boolean solid) {
    }
}

