/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator.util;

import com.viaversion.vialoader.util.ProtocolVersionList;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.lenni0451.mcping.MCPing;
import net.lenni0451.mcping.responses.MCPingResponse;
import net.minecraft.class_124;

public final class ProtocolVersionDetector {
    private static final int TIMEOUT = 3000;

    public static ProtocolVersion get(InetSocketAddress serverAddress, ProtocolVersion clientVersion) {
        MCPingResponse response = (MCPingResponse)MCPing.pingModern((int)clientVersion.getOriginalVersion()).address((SocketAddress)serverAddress).noResolve().timeout(3000, 3000).getSync();
        if (response.version.protocol == clientVersion.getOriginalVersion()) {
            return clientVersion;
        }
        if (ProtocolVersion.isRegistered((int)response.version.protocol)) {
            return ProtocolVersion.getProtocol((int)response.version.protocol);
        }
        for (ProtocolVersion protocol : ProtocolVersionList.getProtocolsNewToOld()) {
            for (String version : protocol.getIncludedVersions()) {
                if (!response.version.name.contains(version)) continue;
                return protocol;
            }
        }
        throw new RuntimeException("Unable to detect the server version\nServer sent an invalid protocol id: " + response.version.protocol + " (" + response.version.name + String.valueOf(class_124.field_1070) + ")");
    }
}

