/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.screen.impl.realms;

import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.save.SaveManager;
import com.viaversion.viafabricplus.screen.VFPList;
import com.viaversion.viafabricplus.screen.VFPListEntry;
import com.viaversion.viafabricplus.screen.VFPScreen;
import com.viaversion.viafabricplus.screen.impl.realms.AcceptInvitationCodeScreen;
import com.viaversion.viafabricplus.util.ConnectionUtil;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.service.realms.BedrockRealmsService;
import net.raphimc.minecraftauth.service.realms.model.RealmsWorld;
import net.raphimc.minecraftauth.step.bedrock.session.StepFullBedrockSession;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import org.apache.logging.log4j.Level;

public final class BedrockRealmsScreen
extends VFPScreen {
    public static final BedrockRealmsScreen INSTANCE = new BedrockRealmsScreen();
    private BedrockRealmsService service;
    private List<RealmsWorld> realmsWorlds;
    private SlotList slotList;
    private class_4185 joinButton;
    private class_4185 leaveButton;

    public BedrockRealmsScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.viafabricplus.bedrock_realms"), true);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.realmsWorlds != null) {
            this.createView();
            return;
        }
        this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.availability_check"));
        CompletableFuture.runAsync(this::loadRealms);
    }

    private void loadRealms() {
        StepFullBedrockSession.FullBedrockSession account = SaveManager.INSTANCE.getAccountsSave().refreshAndGetBedrockAccount();
        if (account == null) {
            this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.warning"));
            return;
        }
        this.service = new BedrockRealmsService(MinecraftAuth.createHttpClient(), "1.21.70", account.getRealmsXsts());
        ((CompletableFuture)this.service.isAvailable().thenAccept(state -> {
            if (state.booleanValue()) {
                ((CompletableFuture)this.service.getWorlds().thenAccept(realmsWorlds -> {
                    this.realmsWorlds = realmsWorlds;
                    this.createView();
                })).exceptionally(throwable -> this.error("Failed to load realm worlds", (Throwable)throwable));
            } else {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.unavailable"));
            }
        })).exceptionally(throwable -> this.error("Failed to check realms availability", (Throwable)throwable));
    }

    private Void error(String message, Throwable throwable) {
        this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.error"));
        ViaFabricPlusImpl.INSTANCE.getLogger().log(Level.ERROR, message, throwable);
        return null;
    }

    private void createView() {
        if (!this.realmsWorlds.isEmpty()) {
            this.setupDefaultSubtitle();
        } else {
            this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.no_worlds"));
        }
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        this.slotList = new SlotList(this, this.field_22787, this.field_22789, this.field_22790, 6 + (9 + 2) * 3, 30, (9 + 2) * 4);
        this.method_37063((class_364)this.slotList);
        this.addRefreshButton(() -> {
            this.realmsWorlds = null;
        });
        int slotWidth = 356;
        int xPos = this.field_22789 / 2 - 178;
        this.joinButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.join"), button -> {
            SlotEntry entry = (SlotEntry)this.slotList.method_25336();
            if (entry.realmsWorld.isExpired()) {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.expired"));
                return;
            }
            if (!entry.realmsWorld.isCompatible()) {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.incompatible"));
                return;
            }
            ((CompletableFuture)this.service.joinWorld(entry.realmsWorld).thenAccept(address -> this.field_22787.execute(() -> ConnectionUtil.connect(address, BedrockProtocolVersion.bedrockLatest)))).exceptionally(throwable -> this.error("Failed to join realm", (Throwable)throwable));
        }).method_46433(xPos, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431();
        this.method_37063((class_364)this.joinButton);
        this.joinButton.field_22763 = false;
        this.leaveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.leave"), button -> {
            SlotEntry entry = (SlotEntry)this.slotList.method_25336();
            ((CompletableFuture)this.service.leaveInvitedRealm(entry.realmsWorld).thenAccept(unused -> {
                this.realmsWorlds.remove(entry.realmsWorld);
                INSTANCE.open(this.prevScreen);
            })).exceptionally(throwable -> this.error("Failed to leave realm", (Throwable)throwable));
        }).method_46433(xPos += 120, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431();
        this.method_37063((class_364)this.leaveButton);
        this.leaveButton.field_22763 = false;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.invite"), button -> {
            AcceptInvitationCodeScreen screen = new AcceptInvitationCodeScreen(code -> ((CompletableFuture)this.service.acceptInvite(code).thenAccept(world -> {
                this.realmsWorlds.add((RealmsWorld)world);
                INSTANCE.open(this);
            })).exceptionally(throwable -> this.error("Failed to accept invite", (Throwable)throwable)));
            screen.open(this);
        }).method_46433(xPos += 120, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431());
    }

    public void method_25393() {
        super.method_25393();
        if (this.slotList != null && this.joinButton != null && this.leaveButton != null) {
            this.joinButton.field_22763 = this.slotList.method_25336() instanceof SlotEntry;
            this.leaveButton.field_22763 = this.slotList.method_25336() instanceof SlotEntry;
        }
    }

    @Override
    protected boolean subtitleCentered() {
        return this.realmsWorlds == null;
    }

    public final class SlotList
    extends VFPList {
        private static double scrollAmount;

        public SlotList(BedrockRealmsScreen this$0, class_310 minecraftClient, int width, int height, int top, int bottom, int entryHeight) {
            super(minecraftClient, width, height, top, bottom, entryHeight);
            for (RealmsWorld realmsWorld : this$0.realmsWorlds) {
                this.method_25321((class_350.class_351)new SlotEntry(this$0, this, realmsWorld));
            }
            this.initScrollY(scrollAmount);
        }

        @Override
        protected void updateSlotAmount(double amount) {
            scrollAmount = amount;
        }

        public int method_25322() {
            return super.method_25322() + 140;
        }
    }

    public final class SlotEntry
    extends VFPListEntry {
        private final SlotList slotList;
        private final RealmsWorld realmsWorld;

        public SlotEntry(BedrockRealmsScreen this$0, SlotList slotList, RealmsWorld realmsWorld) {
            this.slotList = slotList;
            this.realmsWorld = realmsWorld;
        }

        public class_2561 method_37006() {
            return class_2561.method_30163((String)this.realmsWorld.getName());
        }

        @Override
        public void mappedRender(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String worldName;
            class_327 textRenderer = class_310.method_1551().field_1772;
            Object name = "";
            String ownerName = this.realmsWorld.getOwnerName();
            if (ownerName != null && !ownerName.trim().isEmpty()) {
                name = (String)name + ownerName + " - ";
            }
            if ((worldName = this.realmsWorld.getName()) != null && !worldName.trim().isEmpty()) {
                name = (String)name + worldName;
            }
            name = (String)name + " (" + this.realmsWorld.getState() + ")";
            context.method_25303(textRenderer, (String)name, 3, 3, this.slotList.method_25336() == this ? Color.ORANGE.getRGB() : -1);
            Object version = this.realmsWorld.getWorldType();
            String activeVersion = this.realmsWorld.getActiveVersion();
            if (activeVersion != null && !activeVersion.trim().isEmpty()) {
                version = (String)version + " - " + activeVersion;
            }
            context.method_25303(textRenderer, (String)version, entryWidth - textRenderer.method_1727((String)version) - 4 - 3, 3, -1);
            String motd = this.realmsWorld.getMotd();
            if (motd != null) {
                class_2561 class_25612 = class_2561.method_30163((String)motd);
                Objects.requireNonNull(textRenderer);
                this.renderScrollableText(class_25612, entryHeight - 9 - 3, 6);
            }
        }
    }
}

