/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.util;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.lenni0451.reflect.ClassLoaders;
import net.lenni0451.reflect.stream.RStream;
import org.apache.logging.log4j.Logger;

public final class ClassLoaderPriorityUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadOverridingJars(Path path, Logger logger) {
        block7: {
            try {
                Path jars = path.resolve("jars");
                if (!Files.exists(jars, new LinkOption[0])) {
                    Files.createDirectory(jars, new FileAttribute[0]);
                    return;
                }
                File[] files = jars.toFile().listFiles();
                if (files == null || files.length <= 0) break block7;
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader actualLoader = (ClassLoader)RStream.of((Object)oldLoader).fields().by("urlLoader").get();
                    Thread.currentThread().setContextClassLoader(actualLoader);
                    logger.warn("================================");
                    logger.warn("OVERRIDING JARS LOADING! THIS CAN CAUSE UNEXPECTED BEHAVIOR AND ISSUES!");
                    for (File file : files) {
                        if (!file.getName().endsWith(".jar")) continue;
                        ClassLoaders.loadToFront((URL)file.toURI().toURL());
                        logger.warn(" -> {}", (Object)file.getName());
                    }
                    logger.warn("================================");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            catch (Throwable e) {
                logger.error("Failed to load overriding jars", e);
            }
        }
    }
}

