/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.features.networking.resource_pack_header;

import com.viaversion.viafabricplus.protocoltranslator.impl.ViaFabricPlusMappingDataLoader;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_3264;
import net.minecraft.class_6489;
import net.minecraft.class_6595;

public final class ResourcePackHeaderDiff {
    private static final Map<ProtocolVersion, class_6489> GAME_VERSION_DIFF = new HashMap<ProtocolVersion, class_6489>();

    public static void init() {
        JsonObject diff = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("resource-pack-headers.json");
        for (String string : diff.keySet()) {
            ResourcePackHeaderDiff.fill(string, diff.getAsJsonObject(string));
        }
    }

    private static void fill(String name, JsonObject data) {
        ProtocolVersion version = ProtocolVersion.getProtocol((int)data.get("version").getAsInt());
        if (!version.isKnown()) {
            throw new IllegalStateException("Unknown protocol version: " + version.getOriginalVersion());
        }
        JsonElement packFormat = data.get("pack_format");
        if (packFormat.isJsonObject()) {
            int major = packFormat.getAsJsonObject().get("major").getAsInt();
            int minor = packFormat.getAsJsonObject().get("minor").getAsInt();
            ResourcePackHeaderDiff.registerVersion(version, major, minor, name, name);
        } else {
            ResourcePackHeaderDiff.registerVersion(version, packFormat.getAsInt(), -1, name, name);
        }
    }

    public static class_6489 get(ProtocolVersion version) {
        if (!GAME_VERSION_DIFF.containsKey(version)) {
            return class_155.method_16673();
        }
        return GAME_VERSION_DIFF.get(version);
    }

    private static void registerVersion(final ProtocolVersion version, final int majorVersion, final int minorVersion, final String name, final String id) {
        GAME_VERSION_DIFF.put(version, new class_6489(){

            public class_6595 comp_4026() {
                return null;
            }

            public String comp_4024() {
                return id;
            }

            public String comp_4025() {
                return name;
            }

            public int comp_4027() {
                return version.getOriginalVersion();
            }

            public class_11555 method_70592(class_3264 type) {
                if (type == class_3264.field_14188) {
                    return class_11555.method_72320((int)majorVersion, (int)minorVersion);
                }
                throw new UnsupportedOperationException();
            }

            public Date comp_4030() {
                return null;
            }

            public boolean comp_4031() {
                return true;
            }
        });
    }
}

