/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.injection.mixin.base.connection;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.viaversion.viafabricplus.injection.access.base.IConnection;
import com.viaversion.viafabricplus.injection.access.base.IEventLoopGroupHolder;
import com.viaversion.viafabricplus.injection.access.base.ILocalSampleLogger;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.vialoader.netty.CompressionReorderEvent;
import com.viaversion.vialoader.netty.viabedrock.RakNetPingEncapsulationCodec;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.crypto.Cipher;
import net.minecraft.class_12239;
import net.minecraft.class_2528;
import net.minecraft.class_2529;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_9191;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.viabedrock.protocol.RakNetStatusProtocol;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2535.class})
public abstract class MixinConnection
extends SimpleChannelInboundHandler<class_2596<?>>
implements IConnection {
    @Shadow
    public Channel field_11651;
    @Shadow
    private boolean field_11647;
    @Unique
    private UserConnection viaFabricPlus$userConnection;
    @Unique
    private ProtocolVersion viaFabricPlus$serverVersion;
    @Unique
    private Cipher viaFabricPlus$decryptionCipher;

    @Shadow
    public abstract void channelActive(@NotNull ChannelHandlerContext var1) throws Exception;

    @Inject(method={"method_10760"}, at={@At(value="RETURN")})
    private void reorderCompression(int compressionThreshold, boolean rejectBad, CallbackInfo ci) {
        this.field_11651.pipeline().fireUserEventTriggered((Object)CompressionReorderEvent.INSTANCE);
    }

    @Inject(method={"method_10746"}, at={@At(value="HEAD")}, cancellable=true)
    private void storeDecryptionCipher(Cipher decryptionCipher, Cipher encryptionCipher, CallbackInfo ci) {
        if (this.viaFabricPlus$serverVersion != null && this.viaFabricPlus$serverVersion.olderThanOrEqualTo(LegacyProtocolVersion.r1_6_4)) {
            ci.cancel();
            this.viaFabricPlus$decryptionCipher = decryptionCipher;
            if (encryptionCipher == null) {
                throw new IllegalStateException("Encryption cipher is null");
            }
            this.field_11647 = true;
            this.field_11651.pipeline().addBefore("vialegacy-pre-netty-length-remover", "encrypt", (ChannelHandler)new class_2529(encryptionCipher));
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        if (BedrockProtocolVersion.bedrockLatest.equals((Object)this.viaFabricPlus$serverVersion)) {
            this.channelActive(ctx);
        }
    }

    @WrapWithCondition(method={"channelActive"}, at={@At(value="INVOKE", target="Lio/netty/channel/SimpleChannelInboundHandler;channelActive(Lio/netty/channel/ChannelHandlerContext;)V", remap=false)})
    private boolean dontCallChannelActiveTwice(SimpleChannelInboundHandler<class_2596<?>> instance, ChannelHandlerContext channelHandlerContext) {
        return !BedrockProtocolVersion.bedrockLatest.equals((Object)this.viaFabricPlus$serverVersion);
    }

    @Inject(method={"method_10753"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2535;method_52271(Ljava/net/InetSocketAddress;Lnet/minecraft/class_12239;Lnet/minecraft/class_2535;)Lio/netty/channel/ChannelFuture;")})
    private static void setTargetVersion(InetSocketAddress inetSocketAddress, class_12239 eventLoopGroupHolder, class_9191 localSampleLogger, CallbackInfoReturnable<class_2535> cir, @Local class_2535 clientConnection) {
        ILocalSampleLogger mixinMultiValueDebugSampleLogImpl;
        if (localSampleLogger instanceof ILocalSampleLogger && (mixinMultiValueDebugSampleLogImpl = (ILocalSampleLogger)localSampleLogger).viaFabricPlus$getForcedVersion() != null) {
            ((IConnection)clientConnection).viaFabricPlus$setTargetVersion(mixinMultiValueDebugSampleLogImpl.viaFabricPlus$getForcedVersion());
        }
    }

    @WrapWithCondition(method={"method_10753"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2535;method_53505(Lnet/minecraft/class_9191;)V")})
    private static boolean dontSetPerformanceLog(class_2535 instance, class_9191 packetSizeLog) {
        ILocalSampleLogger mixinMultiValueDebugSampleLogImpl;
        return !(packetSizeLog instanceof ILocalSampleLogger) || (mixinMultiValueDebugSampleLogImpl = (ILocalSampleLogger)packetSizeLog).viaFabricPlus$getForcedVersion() == null;
    }

    @Inject(method={"method_52271"}, at={@At(value="HEAD")})
    private static void setTargetVersion(InetSocketAddress inetSocketAddress, class_12239 eventLoopGroupHolder, class_2535 connection, CallbackInfoReturnable<ChannelFuture> cir) {
        ProtocolVersion targetVersion = ((IConnection)connection).viaFabricPlus$getTargetVersion();
        if (targetVersion == null) {
            targetVersion = ProtocolTranslator.getTargetVersion();
        }
        if (targetVersion == ProtocolTranslator.AUTO_DETECT_PROTOCOL) {
            targetVersion = ProtocolTranslator.NATIVE_VERSION;
        }
        ((IConnection)connection).viaFabricPlus$setTargetVersion(targetVersion);
    }

    @WrapOperation(method={"method_52271"}, at={@At(value="INVOKE", target="Lio/netty/bootstrap/Bootstrap;channel(Ljava/lang/Class;)Lio/netty/bootstrap/AbstractBootstrap;", remap=false)})
    private static AbstractBootstrap<?, ?> useRakNetChannelFactory(Bootstrap instance, Class<? extends Channel> channelTypeClass, Operation<AbstractBootstrap<Bootstrap, Channel>> original, @Local(argsOnly=true) class_2535 clientConnection) {
        if (BedrockProtocolVersion.bedrockLatest.equals((Object)((IConnection)clientConnection).viaFabricPlus$getTargetVersion())) {
            return instance.channelFactory((ChannelFactory)(channelTypeClass == EpollSocketChannel.class ? RakChannelFactory.client(EpollDatagramChannel.class) : RakChannelFactory.client(NioDatagramChannel.class)));
        }
        return (AbstractBootstrap)original.call(new Object[]{instance, channelTypeClass});
    }

    @Redirect(method={"method_52271"}, at=@At(value="INVOKE", target="Lio/netty/bootstrap/Bootstrap;connect(Ljava/net/InetAddress;I)Lio/netty/channel/ChannelFuture;", remap=false))
    private static ChannelFuture useRakNetPingHandlers(Bootstrap instance, InetAddress inetHost, int inetPort, @Local(argsOnly=true) class_2535 clientConnection, @Local(argsOnly=true) class_12239 eventLoopGroupHolder) {
        boolean isConnecting = ((IEventLoopGroupHolder)eventLoopGroupHolder).viaFabricPlus$isConnecting();
        if (BedrockProtocolVersion.bedrockLatest.equals((Object)((IConnection)clientConnection).viaFabricPlus$getTargetVersion()) && !isConnecting) {
            return instance.register().syncUninterruptibly().channel().bind((SocketAddress)new InetSocketAddress(0)).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, f -> {
                if (f.isSuccess()) {
                    f.channel().pipeline().replace("viabedrock-raknet-message-codec", "viabedrock-ping-encapsulation", (ChannelHandler)new RakNetPingEncapsulationCodec(new InetSocketAddress(inetHost, inetPort)));
                    f.channel().pipeline().remove("viabedrock-packet-codec");
                    f.channel().pipeline().remove("splitter");
                    UserConnection user = ((IConnection)clientConnection).viaFabricPlus$getUserConnection();
                    user.getProtocolInfo().getPipeline().add((Protocol)RakNetStatusProtocol.INSTANCE);
                }
            }});
        }
        return instance.connect(inetHost, inetPort);
    }

    @Override
    public void viaFabricPlus$setupPreNettyDecryption() {
        if (this.viaFabricPlus$decryptionCipher == null) {
            throw new IllegalStateException("Decryption cipher is null");
        }
        this.field_11647 = true;
        this.field_11651.pipeline().addBefore("vialegacy-pre-netty-length-prepender", "decrypt", (ChannelHandler)new class_2528(this.viaFabricPlus$decryptionCipher));
    }

    @Override
    public UserConnection viaFabricPlus$getUserConnection() {
        return this.viaFabricPlus$userConnection;
    }

    @Override
    public void viaFabricPlus$setUserConnection(UserConnection connection) {
        this.viaFabricPlus$userConnection = connection;
    }

    @Override
    public ProtocolVersion viaFabricPlus$getTargetVersion() {
        return this.viaFabricPlus$serverVersion;
    }

    @Override
    public void viaFabricPlus$setTargetVersion(ProtocolVersion serverVersion) {
        this.viaFabricPlus$serverVersion = serverVersion;
    }
}

