/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.save.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.save.AbstractSave;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.bedrock.BedrockAuthManager;
import net.raphimc.minecraftauth.util.MinecraftAuth4To5Migrator;

public final class AccountsSave
extends AbstractSave {
    private BedrockAuthManager bedrockAccount;
    private CCAccount classicubeAccount;

    public AccountsSave() {
        super("accounts");
    }

    @Override
    public void write(JsonObject object) {
        if (this.bedrockAccount != null) {
            object.add("bedrockV3", (JsonElement)BedrockAuthManager.toJson((BedrockAuthManager)this.bedrockAccount));
        }
        if (this.classicubeAccount != null) {
            object.add("classicube", (JsonElement)this.classicubeAccount.asJson());
        }
    }

    @Override
    public void read(JsonObject object) {
        this.handleAccount("bedrockV2", object, account -> {
            JsonObject newAccount = MinecraftAuth4To5Migrator.migrateBedrockSave((JsonObject)account);
            this.bedrockAccount = BedrockAuthManager.fromJson((HttpClient)MinecraftAuth.createHttpClient(), (String)"1.21.124", (JsonObject)newAccount);
            this.bedrockAccount.getMinecraftMultiplayerToken().refreshIfExpired();
        });
        this.handleAccount("bedrockV3", object, account -> {
            this.bedrockAccount = BedrockAuthManager.fromJson((HttpClient)MinecraftAuth.createHttpClient(), (String)"1.21.124", (JsonObject)account);
        });
        this.handleAccount("classicube", object, account -> {
            this.classicubeAccount = CCAccount.fromJson((JsonObject)account);
        });
    }

    private void handleAccount(String name, JsonObject object, AccountConsumer output) {
        if (object.has(name)) {
            try {
                output.accept(object.get(name).getAsJsonObject());
            }
            catch (Exception e) {
                ViaFabricPlusImpl.INSTANCE.getLogger().error("Failed to read {} account!", (Object)name, (Object)e);
            }
        }
    }

    public BedrockAuthManager getBedrockAccount() {
        return this.bedrockAccount;
    }

    public void setBedrockAccount(BedrockAuthManager bedrockAccount) {
        this.bedrockAccount = bedrockAccount;
    }

    public CCAccount getClassicubeAccount() {
        return this.classicubeAccount;
    }

    public void setClassicubeAccount(CCAccount classicubeAccount) {
        this.classicubeAccount = classicubeAccount;
    }

    @FunctionalInterface
    static interface AccountConsumer {
        public void accept(JsonObject var1) throws Exception;
    }
}

