/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class EXPManager {
    private final SoloLeveling999 plugin;
    private final AttributeManager attributeManager;
    private FileConfiguration expConfig;

    public EXPManager(SoloLeveling999 plugin, AttributeManager attributeManager) {
        this.plugin = plugin;
        this.attributeManager = attributeManager;
    }

    public void addExp(Player player, EntityType mobType) {
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        String mobName = mobType.name();
        int expGained = 0;
        FileConfiguration config = this.plugin.getConfig();
        if (config.contains("exp.passive." + mobName)) {
            expGained = config.getInt("exp.passive." + mobName);
        } else if (config.contains("exp.hostile." + mobName)) {
            expGained = config.getInt("exp.hostile." + mobName);
        }
        if (expGained > 0) {
            int currentExp = attributes.getExp();
            int newExp = currentExp + expGained;
            attributes.setExp(newExp);
            player.sendMessage(ChatColor.GREEN + "+ " + expGained + " EXP");
            this.checkForLevelUp(player);
        }
    }

    public void addPvpExp(Player killer, Player defeated) {
        PlayerAttributes killerAttributes = this.attributeManager.getPlayerAttributes(killer);
        PlayerAttributes defeatedAttributes = this.attributeManager.getPlayerAttributes(defeated);
        if (killerAttributes == null || defeatedAttributes == null) {
            return;
        }
        int pvpExpGained = (int)((double)defeatedAttributes.getLevel() * 1.5);
        int currentExp = killerAttributes.getExp();
        int newExp = currentExp + pvpExpGained;
        killerAttributes.setExp(newExp);
        killer.sendMessage(ChatColor.GREEN + "+ " + pvpExpGained + " PvP EXP from defeating " + defeated.getName());
        this.checkForLevelUp(killer);
    }

    public void handleExpLossOnDeath(Player player) {
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        int expLossPercentage = this.plugin.getConfig().getInt("exp_loss_on_death", 0);
        if (expLossPercentage <= 0) {
            return;
        }
        int currentExp = attributes.getExp();
        int expToLose = (int)((double)currentExp * ((double)expLossPercentage / 100.0));
        int newExp = Math.max(0, currentExp - expToLose);
        attributes.setExp(newExp);
        player.sendMessage(ChatColor.RED + "You lost " + expToLose + " EXP due to death.");
    }

    public void checkForLevelUp(Player player) {
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        int currentLevel = attributes.getLevel();
        int expToNextLevel = 10 * currentLevel;
        if (attributes.getExp() >= expToNextLevel) {
            int excessExp = attributes.getExp() - expToNextLevel;
            attributes.setLevel(currentLevel + 1);
            attributes.setStatPoints(attributes.getStatPoints() + 1);
            attributes.setExp(excessExp);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6You have reached level &b" + attributes.getLevel() + "&6!")));
            this.checkForLevelUp(player);
        }
    }
}

