/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LeaderboardCommand
implements CommandExecutor {
    private final AttributeManager attributeManager;
    private final SoloLeveling999 plugin;

    public LeaderboardCommand(AttributeManager attributeManager, SoloLeveling999 plugin) {
        this.attributeManager = attributeManager;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Map<UUID, PlayerAttributes> allAttributes = this.getAllPlayerAttributesFromFile();
        ArrayList<Map.Entry<UUID, PlayerAttributes>> sortedEntries = new ArrayList<Map.Entry<UUID, PlayerAttributes>>(allAttributes.entrySet());
        sortedEntries.sort((a, b) -> Integer.compare(((PlayerAttributes)b.getValue()).getLevel(), ((PlayerAttributes)a.getValue()).getLevel()));
        sender.sendMessage(ChatColor.GOLD + "=== Top 10 Players by Level ===");
        int rank = 1;
        for (Map.Entry entry : sortedEntries) {
            if (rank > 10) break;
            UUID uuid = (UUID)entry.getKey();
            PlayerAttributes attributes = (PlayerAttributes)entry.getValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            String playerName = player != null ? player.getName() : this.getOfflinePlayerName(uuid);
            sender.sendMessage(ChatColor.YELLOW + String.format("%d. %s - Level %d", rank, playerName, attributes.getLevel()));
            ++rank;
        }
        if (sortedEntries.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "No players found in the database.");
        }
        return true;
    }

    private Map<UUID, PlayerAttributes> getAllPlayerAttributesFromFile() {
        HashMap<UUID, PlayerAttributes> allAttributes = new HashMap<UUID, PlayerAttributes>();
        File attributesFile = new File(this.plugin.getDataFolder(), "attributes.yml");
        if (!attributesFile.exists()) {
            return allAttributes;
        }
        YamlConfiguration attributesConfig = YamlConfiguration.loadConfiguration((File)attributesFile);
        if (attributesConfig.contains("players")) {
            for (String uuidStr : attributesConfig.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    PlayerAttributes attributes = new PlayerAttributes();
                    String path = "players." + uuidStr;
                    attributes.setLevel(attributesConfig.getInt(path + ".level"));
                    attributes.setExp(attributesConfig.getInt(path + ".exp"));
                    attributes.setStatPoints(attributesConfig.getInt(path + ".stat_points"));
                    attributes.setAgility(attributesConfig.getInt(path + ".agility"));
                    attributes.setStrength(attributesConfig.getInt(path + ".strength"));
                    attributes.setVitality(attributesConfig.getInt(path + ".vitality"));
                    attributes.setAttackSpeed(attributesConfig.getInt(path + ".attack_speed"));
                    allAttributes.put(uuid, attributes);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return allAttributes;
    }

    private String getOfflinePlayerName(UUID uuid) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offlinePlayer.hasPlayedBefore()) {
            return offlinePlayer.getName();
        }
        return "Player-" + uuid.toString().substring(0, 8);
    }
}

