/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeApplicator;
import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerConnectionListener
implements Listener {
    private final AttributeManager attributeManager;
    private final AttributeApplicator attributeApplicator;
    private final SoloLeveling999 plugin;

    public PlayerConnectionListener(AttributeManager attributeManager, AttributeApplicator attributeApplicator, SoloLeveling999 plugin) {
        this.attributeManager = attributeManager;
        this.attributeApplicator = attributeApplicator;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.attributeManager.loadPlayer(player);
        this.attributeApplicator.applyAttributes(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.attributeManager.unloadPlayer(player);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        String requiredLevelPath = "required_level." + item.getType().name().toLowerCase();
        int requiredLevel = this.plugin.getConfig().getInt(requiredLevelPath, 0);
        if (requiredLevel > 0 && attributes.getLevel() < requiredLevel) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.RED + "You need to be at least level " + requiredLevel + " to use this item.");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return;
        }
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        String requiredLevelPath = "required_level." + item.getType().name().toLowerCase();
        int requiredLevel = this.plugin.getConfig().getInt(requiredLevelPath, 0);
        if (requiredLevel > 0 && attributes.getLevel() < requiredLevel) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.RED + "You need to be at least level " + requiredLevel + " to use this tool.");
        }
    }
}

