/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeApplicator;
import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResetStatsCommand
implements CommandExecutor {
    private final AttributeManager attributeManager;

    public ResetStatsCommand(AttributeManager attributeManager) {
        this.attributeManager = attributeManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        AttributeApplicator applicator;
        if (args.length != 1) {
            sender.sendMessage("Usage: /resetstats <player>");
            return true;
        }
        Player targetPlayer = sender.getServer().getPlayer(args[0]);
        if (targetPlayer == null) {
            sender.sendMessage("Player not found: " + args[0]);
            return true;
        }
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(targetPlayer);
        if (attributes == null) {
            sender.sendMessage("Player attributes not found for: " + targetPlayer.getName());
            return true;
        }
        int totalAllocatedPoints = attributes.getAgility() + attributes.getStrength() + attributes.getVitality() + attributes.getAttackSpeed();
        attributes.setAgility(0);
        attributes.setStrength(0);
        attributes.setVitality(0);
        attributes.setAttackSpeed(0);
        attributes.setStatPoints(attributes.getStatPoints() + totalAllocatedPoints);
        SoloLeveling999 plugin = (SoloLeveling999)targetPlayer.getServer().getPluginManager().getPlugin("SoloLeveling999");
        if (plugin != null && (applicator = plugin.getAttributeApplicator()) != null) {
            applicator.applyAttributes(targetPlayer);
        }
        sender.sendMessage("Stats for " + targetPlayer.getName() + " have been reset. " + totalAllocatedPoints + " points returned.");
        targetPlayer.sendMessage("Your stats have been reset by an admin. " + totalAllocatedPoints + " points have been returned to you.");
        return true;
    }
}

