/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;

public class AttributeApplicator {
    private final SoloLeveling999 plugin;
    private final AttributeManager attributeManager;

    public AttributeApplicator(SoloLeveling999 plugin, AttributeManager attributeManager) {
        this.plugin = plugin;
        this.attributeManager = attributeManager;
    }

    public void applyAttributes(Player player) {
        AttributeInstance attackSpeed;
        AttributeInstance maxHealth;
        AttributeInstance attackDamage;
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        double agilityScale = this.plugin.getConfig().getDouble("stat_scaling.agility", 0.005);
        double strengthScale = this.plugin.getConfig().getDouble("stat_scaling.strength", 0.1);
        double vitalityScale = this.plugin.getConfig().getDouble("stat_scaling.vitality", 0.5);
        double attackSpeedScale = this.plugin.getConfig().getDouble("stat_scaling.attack_speed", 0.05);
        AttributeInstance movementSpeed = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (movementSpeed != null) {
            double baseSpeed = 0.1;
            movementSpeed.setBaseValue(baseSpeed + (double)attributes.getAgility() * agilityScale);
        }
        if ((attackDamage = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE)) != null) {
            double baseDamage = 1.0;
            attackDamage.setBaseValue(baseDamage + (double)attributes.getStrength() * strengthScale);
        }
        if ((maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null) {
            double baseHealth = 20.0;
            maxHealth.setBaseValue(baseHealth + (double)attributes.getVitality() * vitalityScale);
        }
        if ((attackSpeed = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED)) != null) {
            double baseAttackSpeed = 4.0;
            attackSpeed.setBaseValue(baseAttackSpeed + (double)attributes.getAttackSpeed() * attackSpeedScale);
        }
    }
}

