/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.SoloLeveling999;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class AttributeManager {
    private final SoloLeveling999 plugin;
    private final HashMap<UUID, PlayerAttributes> attributesMap = new HashMap();
    private File attributesFile;
    private FileConfiguration attributesConfig;

    public AttributeManager(SoloLeveling999 plugin) {
        this.plugin = plugin;
        this.setup();
    }

    public void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.attributesFile = new File(this.plugin.getDataFolder(), "attributes.yml");
        if (!this.attributesFile.exists()) {
            try {
                this.attributesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.attributesConfig = YamlConfiguration.loadConfiguration((File)this.attributesFile);
    }

    public void saveAttributes() {
        for (UUID uuid : this.attributesMap.keySet()) {
            PlayerAttributes attributes = this.attributesMap.get(uuid);
            String path = "players." + uuid.toString();
            this.attributesConfig.set(path + ".level", (Object)attributes.getLevel());
            this.attributesConfig.set(path + ".exp", (Object)attributes.getExp());
            this.attributesConfig.set(path + ".stat_points", (Object)attributes.getStatPoints());
            this.attributesConfig.set(path + ".agility", (Object)attributes.getAgility());
            this.attributesConfig.set(path + ".strength", (Object)attributes.getStrength());
            this.attributesConfig.set(path + ".vitality", (Object)attributes.getVitality());
            this.attributesConfig.set(path + ".attack_speed", (Object)attributes.getAttackSpeed());
        }
        try {
            this.attributesConfig.save(this.attributesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.attributesConfig.contains("players." + uuid.toString())) {
            PlayerAttributes attributes = new PlayerAttributes();
            String path = "players." + uuid.toString();
            attributes.setLevel(this.attributesConfig.getInt(path + ".level"));
            attributes.setExp(this.attributesConfig.getInt(path + ".exp"));
            attributes.setStatPoints(this.attributesConfig.getInt(path + ".stat_points"));
            attributes.setAgility(this.attributesConfig.getInt(path + ".agility"));
            attributes.setStrength(this.attributesConfig.getInt(path + ".strength"));
            attributes.setVitality(this.attributesConfig.getInt(path + ".vitality"));
            attributes.setAttackSpeed(this.attributesConfig.getInt(path + ".attack_speed"));
            this.attributesMap.put(uuid, attributes);
        } else {
            this.attributesMap.put(uuid, new PlayerAttributes());
        }
    }

    public void unloadPlayer(Player player) {
        this.savePlayer(player);
        this.attributesMap.remove(player.getUniqueId());
    }

    public void savePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.attributesMap.containsKey(uuid)) {
            PlayerAttributes attributes = this.attributesMap.get(uuid);
            String path = "players." + uuid.toString();
            this.attributesConfig.set(path + ".level", (Object)attributes.getLevel());
            this.attributesConfig.set(path + ".exp", (Object)attributes.getExp());
            this.attributesConfig.set(path + ".stat_points", (Object)attributes.getStatPoints());
            this.attributesConfig.set(path + ".agility", (Object)attributes.getAgility());
            this.attributesConfig.set(path + ".strength", (Object)attributes.getStrength());
            this.attributesConfig.set(path + ".vitality", (Object)attributes.getVitality());
            this.attributesConfig.set(path + ".attack_speed", (Object)attributes.getAttackSpeed());
            try {
                this.attributesConfig.save(this.attributesFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PlayerAttributes getPlayerAttributes(Player player) {
        return this.attributesMap.get(player.getUniqueId());
    }
}

