/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeApplicator;
import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.MainGUI;
import com.example.sololeveling999.PlayerAttributes;
import com.example.sololeveling999.StatsGUI;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class GUIListener
implements Listener {
    private final AttributeManager attributeManager;
    private final StatsGUI statsGUI;
    private final MainGUI mainGUI;
    private final AttributeApplicator attributeApplicator;

    public GUIListener(AttributeManager attributeManager, StatsGUI statsGUI, MainGUI mainGUI, AttributeApplicator attributeApplicator) {
        this.attributeManager = attributeManager;
        this.statsGUI = statsGUI;
        this.mainGUI = mainGUI;
        this.attributeApplicator = attributeApplicator;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            String title = event.getView().getTitle();
            if (title.equals("Stats")) {
                event.setCancelled(true);
                PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
                if (attributes == null) {
                    return;
                }
                int slot = event.getSlot();
                if (attributes.getStatPoints() > 0) {
                    switch (slot) {
                        case 10: {
                            attributes.setAgility(attributes.getAgility() + 1);
                            attributes.setStatPoints(attributes.getStatPoints() - 1);
                            this.attributeApplicator.applyAttributes(player);
                            break;
                        }
                        case 12: {
                            attributes.setStrength(attributes.getStrength() + 1);
                            attributes.setStatPoints(attributes.getStatPoints() - 1);
                            this.attributeApplicator.applyAttributes(player);
                            break;
                        }
                        case 14: {
                            attributes.setVitality(attributes.getVitality() + 1);
                            attributes.setStatPoints(attributes.getStatPoints() - 1);
                            this.attributeApplicator.applyAttributes(player);
                            break;
                        }
                        case 16: {
                            attributes.setAttackSpeed(attributes.getAttackSpeed() + 1);
                            attributes.setStatPoints(attributes.getStatPoints() - 1);
                            this.attributeApplicator.applyAttributes(player);
                        }
                    }
                    this.statsGUI.open(player);
                }
                if (slot == 18) {
                    player.closeInventory();
                }
            } else if (title.equals("Main Menu")) {
                event.setCancelled(true);
                int slot = event.getSlot();
                if (slot == 11) {
                    this.statsGUI.open(player);
                }
            }
        }
    }
}

