/*
 * Decompiled with CFR 0.152.
 */
package com.example.sololeveling999;

import com.example.sololeveling999.AttributeManager;
import com.example.sololeveling999.PlayerAttributes;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainGUI {
    private final AttributeManager attributeManager;

    public MainGUI(AttributeManager attributeManager) {
        this.attributeManager = attributeManager;
    }

    public void open(Player player) {
        PlayerAttributes attributes = this.attributeManager.getPlayerAttributes(player);
        if (attributes == null) {
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Main Menu");
        ItemStack stats = this.createItem(Material.BLACK_CONCRETE, "Stats", "Click to open the stats menu.");
        gui.setItem(11, stats);
        int expToNextLevel = 10 * attributes.getLevel();
        ItemStack level = this.createItem(Material.BLACK_CONCRETE, "Level", "Level: " + attributes.getLevel() + "\nEXP: " + attributes.getExp() + " / " + expToNextLevel);
        gui.setItem(13, level);
        ItemStack comingSoon = this.createItem(Material.BLACK_CONCRETE, "More coming soon", "");
        gui.setItem(15, comingSoon);
        player.openInventory(gui);
    }

    private ItemStack createItem(Material material, String name, String lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        ArrayList<String> lores = new ArrayList<String>();
        for (String line : lore.split("\\n")) {
            lores.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        meta.setLore(lores);
        item.setItemMeta(meta);
        return item;
    }
}

