/*
 * Decompiled with CFR 0.152.
 */
package org.elias.fastmath;

import org.apache.commons.math3.util.FastMath;

public class MathUtil {
    private static final int INITIAL_TABLE_SIZE = 4096;
    private static float[] trigTable;
    private static float radToIndex;

    public static void initialize(int tableSize) {
        trigTable = new float[tableSize];
        radToIndex = (float)tableSize / ((float)Math.PI * 2);
        for (int j = 0; j < tableSize; ++j) {
            MathUtil.trigTable[j] = MathUtil.toFloat(FastMath.sin((double)((double)j * 2.0 * Math.PI / (double)tableSize)));
        }
    }

    public static float[] sinAndCos(float radians) {
        if (trigTable == null) {
            MathUtil.initialize(4096);
        }
        int sinIndex = (int)(radians * radToIndex) & trigTable.length - 1;
        int cosIndex = (int)(((double)(radians * radToIndex) + (double)trigTable.length / 4.0) % (double)trigTable.length);
        if (cosIndex < 0) {
            cosIndex += trigTable.length;
        }
        return new float[]{trigTable[sinIndex], trigTable[cosIndex]};
    }

    private static float toFloat(double d) {
        return (float)((double)Math.round(d * 1.0E8) / 1.0E8);
    }
}

