/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.anomalyrephased.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class AnomalyConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ASHADOW_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_AHUNTSHADOW_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_AHAUNT_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_AFIND_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_APEEK_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ALOOK_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_AHUNT_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ACHASE_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_AFOOL_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ASTATUE_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ADARKNESS_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ACOW_SPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> ENCOUNTER_MIN;
    public static final ForgeConfigSpec.ConfigValue<Double> ENCOUNTER_MAX;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SLEEP_EVENTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> NIGHT_EVENTS;
    public static final ForgeConfigSpec.ConfigValue<Double> NIGHT_EVENT_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> START_TIME;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_PHASE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DEBUG;
    public static final ForgeConfigSpec.ConfigValue<Double> PROBABILITY_MULTIPLIER;

    static {
        BUILDER.push("Spawning");
        CAN_ASHADOW_SPAWN = BUILDER.comment("Determines if Anomaly Shadow can spawn naturally").define("anomaly_shadow", true);
        CAN_AHUNTSHADOW_SPAWN = BUILDER.comment("Determines if Anomaly Hunt Shadow can spawn naturally").define("anomaly_hunt_shadow", true);
        CAN_AHAUNT_SPAWN = BUILDER.comment("Determines if Anomaly Haunt can spawn naturally").define("anomaly_haunt", true);
        CAN_AFIND_SPAWN = BUILDER.comment("Determines if Anomaly Find can spawn naturally").define("anomaly_find", true);
        CAN_APEEK_SPAWN = BUILDER.comment("Determines if Anomaly Peek can spawn naturally").define("anomaly_peek", true);
        CAN_ALOOK_SPAWN = BUILDER.comment("Determines if Anomaly Look can spawn naturally").define("anomaly_look", true);
        CAN_AHUNT_SPAWN = BUILDER.comment("Determines if Anomaly Hunt can spawn naturally").define("anomaly_hunt", true);
        CAN_ACHASE_SPAWN = BUILDER.comment("Determines if Anomaly Chase can spawn naturally").define("anomaly_chase", true);
        CAN_AFOOL_SPAWN = BUILDER.comment("Determines if Anomaly Fool can spawn naturally").define("anomaly_fool", true);
        CAN_ASTATUE_SPAWN = BUILDER.comment("Determines if Anomaly Statue can spawn naturally").define("anomaly_statue", true);
        CAN_ADARKNESS_SPAWN = BUILDER.comment("Determines if Anomaly Darkness can spawn naturally").define("anomaly_darkness", true);
        CAN_ACOW_SPAWN = BUILDER.comment("Determines if Anomaly Cow can spawn naturally").define("anomaly_cow", true);
        ENCOUNTER_MIN = BUILDER.comment("Minimum value for the random cooldown between every anomaly spawn. Measured in ticks").define("min_cooldown", (Object)700.0);
        ENCOUNTER_MAX = BUILDER.comment("Maximum value for the random cooldown between every anomaly spawn (This value determines until when the anomaly CANNOT spawn after an encounter). Measured in ticks").define("max_cooldown", (Object)6000.0);
        BUILDER.pop();
        BUILDER.push("Events");
        SLEEP_EVENTS = BUILDER.comment("Determines if sleep events are activated, if false, there will be no sleep events between phases").define("sleep_events", true);
        NIGHT_EVENTS = BUILDER.comment("If disabled, no events will occur during night (e.g. red eye moon event)").define("night_events", true);
        NIGHT_EVENT_CHANCE = BUILDER.comment("Chance for a night event to occur (reminder that it runs every tick during day) WARNING! This doesn't affect sleep events").define("night_event_chance", (Object)0.05);
        START_TIME = BUILDER.comment("The number of days it takes for the anomaly to reach phase 1").define("start_time", (Object)7.0);
        MAX_PHASE = BUILDER.define("max_phase", (Object)100.0);
        BUILDER.pop();
        BUILDER.push("Other");
        DEBUG = BUILDER.comment("Allows the use of every /anomalydata command").define("debug_mode", false);
        PROBABILITY_MULTIPLIER = BUILDER.comment("A multiplier that increments the probability of going into the next phase each time you encounter an anomaly").define("probability_multiplier", (Object)1.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

