/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc;

import com.google.common.base.Functions;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6862;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.blocks.ColoredBlocks;
import pers.solid.mishang.uc.blocks.HandrailBlocks;
import pers.solid.mishang.uc.blocks.HungSignBlocks;
import pers.solid.mishang.uc.blocks.LightBlocks;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.blocks.RoadMarkBlocks;
import pers.solid.mishang.uc.blocks.RoadSlabBlocks;
import pers.solid.mishang.uc.blocks.StandingSignBlocks;
import pers.solid.mishang.uc.blocks.WallSignBlocks;
import pers.solid.mishang.uc.item.MishangucItems;
import pers.solid.mishang.uc.text.TextContext;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.VerticalAlign;

public class MishangUtils {
    public static final @Unmodifiable BiMap<class_1767, Integer> COLOR_TO_OUTLINE_COLOR = (BiMap)Arrays.stream(class_1767.values()).collect(ImmutableBiMap.toImmutableBiMap((Function)Functions.identity(), MishangUtils::toSignOutlineColor));
    private static final Supplier<ImmutableList<class_2248>> memoizedBlocks = Suppliers.memoize(MishangUtils::blocksInternal);
    private static final ImmutableSet<class_2248> WOODS = ImmutableSet.of((Object)class_2246.field_10126, (Object)class_2246.field_10155, (Object)class_2246.field_10307, (Object)class_2246.field_10303, (Object)class_2246.field_9999, (Object)class_2246.field_10178, (Object[])new class_2248[]{class_2246.field_37549, class_2246.field_22505, class_2246.field_22503, class_2246.field_42733});
    private static final ImmutableSet<class_2248> STRIPPED_WOODS = ImmutableSet.of((Object)class_2246.field_10250, (Object)class_2246.field_10558, (Object)class_2246.field_10204, (Object)class_2246.field_10084, (Object)class_2246.field_10103, (Object)class_2246.field_10374, (Object[])new class_2248[]{class_2246.field_37550, class_2246.field_22506, class_2246.field_22504, class_2246.field_42730});
    private static final ImmutableSet<class_2248> PLANKS = ImmutableSet.of((Object)class_2246.field_10161, (Object)class_2246.field_9975, (Object)class_2246.field_10148, (Object)class_2246.field_10334, (Object)class_2246.field_10218, (Object)class_2246.field_10075, (Object[])new class_2248[]{class_2246.field_37577, class_2246.field_22127, class_2246.field_22126, class_2246.field_42751, class_2246.field_40294});
    private static final ImmutableSet<class_2248> CONCRETES = ImmutableSet.of((Object)class_2246.field_10107, (Object)class_2246.field_10210, (Object)class_2246.field_10585, (Object)class_2246.field_10242, (Object)class_2246.field_10542, (Object)class_2246.field_10421, (Object[])new class_2248[]{class_2246.field_10434, class_2246.field_10038, class_2246.field_10172, class_2246.field_10308, class_2246.field_10206, class_2246.field_10011, class_2246.field_10439, class_2246.field_10367, class_2246.field_10058, class_2246.field_10458});
    private static final ImmutableSet<class_2248> TERRACOTTAS = ImmutableSet.of((Object)class_2246.field_10611, (Object)class_2246.field_10184, (Object)class_2246.field_10015, (Object)class_2246.field_10325, (Object)class_2246.field_10143, (Object)class_2246.field_10014, (Object[])new class_2248[]{class_2246.field_10444, class_2246.field_10349, class_2246.field_10590, class_2246.field_10235, class_2246.field_10570, class_2246.field_10409, class_2246.field_10123, class_2246.field_10526, class_2246.field_10328, class_2246.field_10626});
    private static final ImmutableSet<class_2248> WOOLS = ImmutableSet.of((Object)class_2246.field_10446, (Object)class_2246.field_10095, (Object)class_2246.field_10215, (Object)class_2246.field_10294, (Object)class_2246.field_10490, (Object)class_2246.field_10028, (Object[])new class_2248[]{class_2246.field_10459, class_2246.field_10423, class_2246.field_10222, class_2246.field_10619, class_2246.field_10259, class_2246.field_10514, class_2246.field_10113, class_2246.field_10170, class_2246.field_10314, class_2246.field_10146});
    private static final ImmutableSet<class_2248> STAINED_GLASSES = ImmutableSet.of((Object)class_2246.field_10087, (Object)class_2246.field_10227, (Object)class_2246.field_10574, (Object)class_2246.field_10271, (Object)class_2246.field_10049, (Object)class_2246.field_10157, (Object[])new class_2248[]{class_2246.field_10317, class_2246.field_10555, class_2246.field_9996, class_2246.field_10248, class_2246.field_10399, class_2246.field_10060, class_2246.field_10073, class_2246.field_10357, class_2246.field_10272, class_2246.field_9997});
    public static final Codec<Integer> COLOR_CODEC = Codec.INT.xmap(integer -> class_9848.method_61320((int)integer) < 1 ? class_9848.method_61334((int)integer) : integer, Function.identity()).mapResult((Codec.ResultFunction)new Codec.ResultFunction<Integer>(){
        public static final Decoder<Integer> COLOR_CODEC_STRING = Codec.STRING.flatMap(s -> class_5251.method_27719((String)s).map(class_5251::method_27716));
        public static final Codec<Integer> COLOR_CODEC_LIST = Codec.list((Codec)Codec.INT).flatXmap(integers -> {
            if (integers.size() < 3 || integers.size() > 4) {
                return DataResult.error(() -> "The length of the list that indicates a color should be 3 or 4, but got " + integers.size());
            }
            int red = (Integer)integers.get(0) & 0xFF;
            int green = (Integer)integers.get(1) & 0xFF;
            int blue = (Integer)integers.get(2) & 0xFF;
            int alpha = integers.size() > 3 ? (Integer)integers.get(3) & 0xFF : 255;
            return DataResult.success((Object)(red << 16 | green << 8 | blue | alpha << 24));
        }, integer -> DataResult.success((Object)IntList.of((int[])new int[]{integer >> 16 & 0xFF, integer >> 8 & 0xFF, integer & 0xFF, integer >> 24 & 0xFF})));

        public <T> DataResult<Pair<Integer, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<Integer, T>> a) {
            if (a.isSuccess()) {
                return a;
            }
            if (ops.getStringValue(input).isSuccess()) {
                return COLOR_CODEC_STRING.decode(ops, input);
            }
            if (ops.getList(input).isSuccess()) {
                return COLOR_CODEC_LIST.decode(ops, input);
            }
            if (ops.getMapValues(input).isSuccess()) {
                DataResult signResult = ops.get(input, "signColor");
                if (signResult.isSuccess()) {
                    return signResult.flatMap(t -> class_1767.field_41600.map(class_1767::method_16357).decode(ops, t));
                }
                DataResult fireworkResult = ops.get(input, "fireworkColor");
                if (fireworkResult.isSuccess()) {
                    return fireworkResult.flatMap(t -> class_1767.field_41600.map(class_1767::method_7790).decode(ops, t));
                }
                DataResult mapResult = ops.get(input, "mapColor");
                if (mapResult.isSuccess()) {
                    return mapResult.flatMap(t -> class_1767.field_41600.map(dyeColor -> dyeColor.method_7794().field_16011).decode(ops, t));
                }
                return DataResult.error(() -> "Missing field: singColor, fireworkColor or mapColor");
            }
            return DataResult.error(() -> "Cannot parse color");
        }

        public <T> DataResult<T> coApply(DynamicOps<T> ops, Integer input, DataResult<T> t) {
            return t;
        }
    });
    public static final Supplier<ImmutableMap<class_1767, class_6862<class_1792>>> DYE_ITEM_TAGS = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)class_1767.field_7963, (Object)ConventionalItemTags.BLACK_DYES).put((Object)class_1767.field_7966, (Object)ConventionalItemTags.BLUE_DYES).put((Object)class_1767.field_7957, (Object)ConventionalItemTags.BROWN_DYES).put((Object)class_1767.field_7955, (Object)ConventionalItemTags.CYAN_DYES).put((Object)class_1767.field_7944, (Object)ConventionalItemTags.GRAY_DYES).put((Object)class_1767.field_7942, (Object)ConventionalItemTags.GREEN_DYES).put((Object)class_1767.field_7951, (Object)ConventionalItemTags.LIGHT_BLUE_DYES).put((Object)class_1767.field_7967, (Object)ConventionalItemTags.LIGHT_GRAY_DYES).put((Object)class_1767.field_7961, (Object)ConventionalItemTags.LIME_DYES).put((Object)class_1767.field_7958, (Object)ConventionalItemTags.MAGENTA_DYES).put((Object)class_1767.field_7946, (Object)ConventionalItemTags.ORANGE_DYES).put((Object)class_1767.field_7954, (Object)ConventionalItemTags.PINK_DYES).put((Object)class_1767.field_7945, (Object)ConventionalItemTags.PURPLE_DYES).put((Object)class_1767.field_7964, (Object)ConventionalItemTags.RED_DYES).put((Object)class_1767.field_7952, (Object)ConventionalItemTags.WHITE_DYES).put((Object)class_1767.field_7947, (Object)ConventionalItemTags.YELLOW_DYES).build());

    public static boolean isWooden(class_2248 block) {
        return MishangUtils.isWood(block) || MishangUtils.isStrippedWood(block) || MishangUtils.isPlanks(block);
    }

    public static boolean isWood(class_2248 block) {
        return WOODS.contains((Object)block);
    }

    public static boolean isStrippedWood(class_2248 block) {
        return STRIPPED_WOODS.contains((Object)block);
    }

    public static boolean isPlanks(class_2248 block) {
        return PLANKS.contains((Object)block) || block == ColoredBlocks.COLORED_PLANKS;
    }

    public static boolean isConcrete(class_2248 block) {
        return CONCRETES.contains((Object)block) || block == ColoredBlocks.COLORED_CONCRETE;
    }

    public static boolean isTerracotta(class_2248 block) {
        return TERRACOTTAS.contains((Object)block) || block == ColoredBlocks.COLORED_TERRACOTTA;
    }

    public static boolean isWool(class_2248 block) {
        return WOOLS.contains((Object)block) || block == ColoredBlocks.COLORED_WOOL;
    }

    public static boolean isStained_glass(class_2248 block) {
        return STAINED_GLASSES.contains((Object)block) || block == ColoredBlocks.COLORED_GLASS;
    }

    public static EnumMap<class_2350, @NotNull class_265> createDirectionToShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        EnumMap<class_2350, class_265> map = new EnumMap<class_2350, class_265>(class_2350.class);
        map.put(class_2350.field_11036, class_2248.method_9541((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        map.put(class_2350.field_11033, class_2248.method_9541((double)(16.0 - maxX), (double)(16.0 - maxY), (double)(16.0 - maxZ), (double)(16.0 - minX), (double)(16.0 - minY), (double)(16.0 - minZ)));
        map.put(class_2350.field_11034, class_2248.method_9541((double)minY, (double)minZ, (double)minX, (double)maxY, (double)maxZ, (double)maxX));
        map.put(class_2350.field_11039, class_2248.method_9541((double)(16.0 - maxY), (double)(16.0 - maxZ), (double)(16.0 - maxX), (double)(16.0 - minY), (double)(16.0 - minZ), (double)(16.0 - minX)));
        map.put(class_2350.field_11035, class_2248.method_9541((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY));
        map.put(class_2350.field_11043, class_2248.method_9541((double)(16.0 - maxX), (double)(16.0 - maxZ), (double)(16.0 - maxY), (double)(16.0 - minX), (double)(16.0 - minZ), (double)(16.0 - minY)));
        return map;
    }

    public static Map<class_2350, @Nullable class_265> createHorizontalDirectionToShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        EnumMap<class_2350, class_265> map = new EnumMap<class_2350, class_265>(class_2350.class);
        map.put(class_2350.field_11035, class_2248.method_9541((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        map.put(class_2350.field_11039, class_2248.method_9541((double)(16.0 - maxZ), (double)minY, (double)minX, (double)(16.0 - minZ), (double)maxY, (double)maxX));
        map.put(class_2350.field_11043, class_2248.method_9541((double)(16.0 - maxX), (double)minY, (double)(16.0 - maxZ), (double)(16.0 - minX), (double)maxY, (double)(16.0 - minZ)));
        map.put(class_2350.field_11034, class_2248.method_9541((double)minZ, (double)minY, (double)(16.0 - maxX), (double)maxZ, (double)maxY, (double)(16.0 - minX)));
        return map;
    }

    @SafeVarargs
    public static Map<class_2350, class_265> createDirectionToUnionShape(Map<class_2350, class_265> firstDirectionToShape, Map<class_2350, class_265> ... directionToShapes) {
        EnumMap<class_2350, class_265> map = new EnumMap<class_2350, class_265>(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            class_265 first = firstDirectionToShape.get(direction);
            if (first == null) continue;
            map.put(direction, class_259.method_17786((class_265)first, (class_265[])((class_265[])Arrays.stream(directionToShapes).filter(Objects::nonNull).map(directionToShape -> (class_265)directionToShape.get(direction)).toArray(class_265[]::new))));
        }
        return map;
    }

    @Nullable
    public static class_1767 colorBySignColor(int signColor) {
        for (class_1767 color : class_1767.values()) {
            if (color.method_16357() != signColor) continue;
            return color;
        }
        return null;
    }

    private static int toSignOutlineColor(class_1767 color) {
        return MishangUtils.toSignOutlineColor(color.method_16357());
    }

    public static int toSignOutlineColor(int color) {
        if ((color & 0xFFFFFF) == 0) {
            return color & 0xFF000000 | 0xF0EBCC;
        }
        int j = (int)((double)class_9848.method_61327((int)color) * 0.4);
        int k = (int)((double)class_9848.method_61329((int)color) * 0.4);
        int l = (int)((double)class_9848.method_61331((int)color) * 0.4);
        return class_9848.method_61324((int)class_9848.method_61320((int)color), (int)j, (int)k, (int)l);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.AvailableSince(value="0.2.0")
    @ApiStatus.Internal
    private static @Unmodifiable ImmutableList<@NotNull class_2248> blocksInternal() {
        @NotNull ImmutableList build = (ImmutableList)Streams.concat((Stream[])new Stream[]{MishangUtils.instanceStream(RoadBlocks.class, class_2248.class), RoadSlabBlocks.SLABS.stream(), MishangUtils.instanceStream(RoadMarkBlocks.class, class_2248.class), MishangUtils.instanceStream(LightBlocks.class, class_2248.class), MishangUtils.instanceStream(HungSignBlocks.class, class_2248.class), MishangUtils.instanceStream(WallSignBlocks.class, class_2248.class), MishangUtils.instanceStream(StandingSignBlocks.class, class_2248.class), MishangUtils.instanceStream(HandrailBlocks.class, class_2248.class).flatMap(block -> {
            Stream<class_2248> stream;
            if (block instanceof HandrailBlock) {
                HandrailBlock handrailBlock = (HandrailBlock)block;
                stream = Arrays.stream(handrailBlock.selfAndVariants());
            } else {
                stream = Stream.of(block);
            }
            return stream;
        }), MishangUtils.instanceStream(ColoredBlocks.class, class_2248.class)}).map(Objects::requireNonNull).collect(ImmutableList.toImmutableList());
        if (build.isEmpty()) {
            throw new AssertionError((Object)"The collection returned is empty, which is not expected. You may have to report to the author of Mishang Urban Construction mod.");
        }
        return build;
    }

    @ApiStatus.AvailableSince(value="0.2.0")
    public static @Unmodifiable ImmutableList<class_2248> blocks() {
        return memoizedBlocks.get();
    }

    @ApiStatus.AvailableSince(value="0.2.0")
    public static @Unmodifiable List<class_1792> items() {
        return MishangucItems.items();
    }

    public static Stream<Field> fieldStream(Class<?> containerClass) {
        return Arrays.stream(containerClass.getFields()).filter(field -> {
            int modifier = field.getModifiers();
            return Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && Modifier.isFinal(modifier);
        });
    }

    public static <T> Stream<Map.Entry<Field, T>> instanceEntryStream(Stream<Field> fieldStream, Class<T> castToClass) {
        return fieldStream.map(field -> {
            Object o;
            try {
                field.setAccessible(true);
                o = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Cannot access value of the field in Mishang Urban Construction mod.", e);
            }
            if (castToClass.isInstance(o)) {
                return Maps.immutableEntry((Object)field, castToClass.cast(o));
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static <T> Stream<Map.Entry<Field, T>> instanceEntryStream(Class<?> containerClass, Class<T> castToClass) {
        return MishangUtils.instanceEntryStream(MishangUtils.fieldStream(containerClass), castToClass);
    }

    public static <T> Stream<@NotNull T> instanceStream(Class<?> containerClass, Class<T> castToClass) {
        return MishangUtils.instanceEntryStream(containerClass, castToClass).map(Map.Entry::getValue);
    }

    public static void rearrange(Collection<TextContext> textContexts) {
        EnumMap<VerticalAlign, List> directionToContexts = new EnumMap<VerticalAlign, List>(VerticalAlign.class);
        for (TextContext textContext : textContexts) {
            if (textContext.absolute) continue;
            directionToContexts.putIfAbsent(textContext.verticalAlign, new ArrayList());
            ((List)directionToContexts.get((Object)textContext.verticalAlign)).add(textContext);
        }
        directionToContexts.forEach((verticalAlign, list) -> {
            float stackedHeight = 0.0f;
            for (TextContext textContext : list) {
                textContext.offsetY = stackedHeight += textContext.getMarginTop() / 2.0f;
                stackedHeight += textContext.getHeight() / 2.0f;
                stackedHeight += textContext.getMarginTop() / 2.0f;
            }
            for (TextContext textContext : list) {
                switch (verticalAlign) {
                    case MIDDLE: {
                        textContext.offsetY -= (stackedHeight - textContext.getHeight() / 2.0f) / 2.0f;
                        break;
                    }
                    case BOTTOM: {
                        textContext.offsetY -= stackedHeight - textContext.getHeight() / 2.0f;
                    }
                }
            }
        });
    }

    public static class_2350.class_2351 rotateAxis(class_2470 rotation, class_2350.class_2351 axis) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch (axis) {
                    case field_11048: {
                        yield class_2350.class_2351.field_11051;
                    }
                    case field_11051: {
                        yield class_2350.class_2351.field_11048;
                    }
                }
                yield axis;
            }
            default -> axis;
        };
    }

    public static <T extends Comparable<T>> class_2680 with(class_2680 state, class_2769<T> property, String name) {
        return property.method_11900(name).map(value -> (class_2680)state.method_11657(property, value)).orElse(state);
    }

    @ApiStatus.AvailableSince(value="0.2.1")
    public static class_5250 describeColor(int color) {
        return MishangUtils.describeColor(color, (class_2561)TextBridge.literal(MishangUtils.formatColorHex(color)));
    }

    public static class_5250 describeColor(int color, class_2561 text) {
        return TextBridge.empty().method_10852((class_2561)TextBridge.literal("\u25a0").method_27694(style -> style.method_36139(color))).method_10852(text);
    }

    public static String formatColorHex(int color) {
        int alpha = color >> 24 & 0xFF;
        return alpha != 255 ? String.format("#%08x", (color & 0xFFFFFF) << 8 | alpha) : String.format("#%06x", color & 0xFFFFFF);
    }

    @NotNull
    public static DataResult<Integer> parseColor(String s) {
        if (s.startsWith("#")) {
            try {
                String hexPart = s.substring(1);
                int i = Integer.parseUnsignedInt(hexPart, 16);
                switch (hexPart.length()) {
                    case 4: {
                        int r = i >> 12 & 0xF;
                        int g = i >> 8 & 0xF;
                        int b = i >> 4 & 0xF;
                        int a = i & 0xF;
                        return DataResult.success((Object)class_9848.method_61324((int)(a * 17), (int)(r * 17), (int)(g * 17), (int)(b * 17)));
                    }
                    case 3: {
                        int r = i >> 8 & 0xF;
                        int g = i >> 4 & 0xF;
                        int b = i & 0xF;
                        return DataResult.success((Object)class_9848.method_61324((int)255, (int)(r * 17), (int)(g * 17), (int)(b * 17)));
                    }
                    case 8: {
                        int rgb = i >> 8 & 0xFFFFFF;
                        int a = i & 0xFF;
                        return DataResult.success((Object)class_9848.method_61330((int)a, (int)rgb));
                    }
                    case 6: {
                        return DataResult.success((Object)(i & 0xFFFFFF | 0xFF000000));
                    }
                }
                return DataResult.error(() -> "Invalid value length: " + s);
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Cannot parse number value: " + s);
            }
        }
        return class_5251.method_27719((String)s).map(textColor -> textColor.method_27716() | 0xFF000000);
    }

    public static class_5250 describeShortcut(class_2561 shortcut) {
        return TextBridge.translatable("message.mishanguc.keyboard_shortcut.composed", shortcut).method_27692(class_124.field_1080);
    }

    @ApiStatus.AvailableSince(value="0.2.4")
    public static String composeStraightLineTexture(LineColor lineColor, LineType lineType) {
        if (lineType == LineType.NORMAL) {
            return lineColor.method_15434() + "_straight_line";
        }
        return lineColor.method_15434() + "_straight_" + lineType.method_15434() + "_line";
    }

    public static String composeAngleLineTexture(LineColor lineColor, LineType lineType, boolean bevel) {
        return lineColor.method_15434() + "_" + (String)(lineType == LineType.NORMAL ? "" : lineColor.method_15434() + "_") + (bevel ? "bevel" : "right") + "_angle_line";
    }

    public static int readColorFromNbtElement(class_2520 nbtColor) {
        return COLOR_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbtColor).result().map(Pair::getFirst).orElse(0);
    }

    public static String numberToString(float value) {
        int intValue = (int)value;
        return value == (float)intValue ? Integer.toString(intValue) : Float.toString(value);
    }
}

