/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10402;
import net.minecraft.class_10459;
import net.minecraft.class_10482;
import net.minecraft.class_10493;
import net.minecraft.class_10712;
import net.minecraft.class_11515;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5616;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.apache.commons.lang3.Validate;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.MishangucRules;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.block.StandingSignBlock;
import pers.solid.mishang.uc.blockentity.ColoredBlockEntity;
import pers.solid.mishang.uc.blockentity.HungSignBlockEntity;
import pers.solid.mishang.uc.blockentity.MishangucBlockEntities;
import pers.solid.mishang.uc.blockentity.StandingSignBlockEntity;
import pers.solid.mishang.uc.blockentity.WallSignBlockEntity;
import pers.solid.mishang.uc.blocks.MishangucBlocks;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.item.CarryingToolTypeProperty;
import pers.solid.mishang.uc.item.ColorMixtureTypeProperty;
import pers.solid.mishang.uc.item.ColoredTintSource;
import pers.solid.mishang.uc.item.DataTagToolItem;
import pers.solid.mishang.uc.item.ExplosionCreateFireProperty;
import pers.solid.mishang.uc.item.ExplosionPowerProperty;
import pers.solid.mishang.uc.item.FastBuildingRangeProperty;
import pers.solid.mishang.uc.item.TransparencyPropertyProperty;
import pers.solid.mishang.uc.networking.EditSignPayload;
import pers.solid.mishang.uc.networking.GetBlockDataPayload;
import pers.solid.mishang.uc.networking.GetEntityDataPayload;
import pers.solid.mishang.uc.networking.RuleChangedPayload;
import pers.solid.mishang.uc.render.HungSignBlockEntityRenderer;
import pers.solid.mishang.uc.render.RendersBeforeOutline;
import pers.solid.mishang.uc.render.RendersBlockOutline;
import pers.solid.mishang.uc.render.StandingSignBlockEntityRenderer;
import pers.solid.mishang.uc.render.WallSignBlockEntityRenderer;
import pers.solid.mishang.uc.screen.HungSignBlockEditScreen;
import pers.solid.mishang.uc.screen.StandingSignBlockEditScreen;
import pers.solid.mishang.uc.screen.WallSignBlockEditScreen;
import pers.solid.mishang.uc.util.WithMishangTooltip;

@Environment(value=EnvType.CLIENT)
public class MishangucClient
implements ClientModInitializer {
    public static final AtomicReference<MishangucRules.ToolAccess> CLIENT_FORCE_PLACING_TOOL_ACCESS = new AtomicReference<MishangucRules.ToolAccess>(MishangucRules.ToolAccess.CREATIVE_ONLY);
    public static final AtomicReference<MishangucRules.ToolAccess> CLIENT_CARRYING_TOOL_ACCESS = new AtomicReference<MishangucRules.ToolAccess>(MishangucRules.ToolAccess.ALL);

    public void onInitializeClient() {
        MishangucClient.registerBlockLayers();
        MishangucClient.registerRenderEvents();
        MishangucClient.registerBlockEntityRenderers();
        MishangucClient.registerBlockColors();
        MishangucClient.registerNetworking();
        MishangucClient.registerItemProperties();
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltipType, list) -> {
            class_1792 patt2$temp;
            class_1747 blockItem;
            class_2248 patt1$temp;
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof class_1747 && (patt1$temp = (blockItem = (class_1747)patt0$temp).method_7711()) instanceof WithMishangTooltip) {
                WithMishangTooltip withMishangTooltip = (WithMishangTooltip)patt1$temp;
                withMishangTooltip.getMishangTooltip(itemStack, tooltipContext, list, tooltipType);
            }
            if ((patt2$temp = itemStack.method_7909()) instanceof WithMishangTooltip) {
                WithMishangTooltip withMishangTooltip = (WithMishangTooltip)patt2$temp;
                withMishangTooltip.getMishangTooltip(itemStack, tooltipContext, list, tooltipType);
            }
        });
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltipType, list) -> {
            class_10712 tooltipDisplayComponent = (class_10712)itemStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
            itemStack.method_57369(MishangucComponents.CARRYING_TOOL_DATA, tooltipContext, tooltipDisplayComponent, list::add, tooltipType);
            itemStack.method_57369(MishangucComponents.EXPLOSION_TOOL_DATA, tooltipContext, tooltipDisplayComponent, list::add, tooltipType);
            itemStack.method_57369(MishangucComponents.FAST_BUILDING_TOOL_DATA, tooltipContext, tooltipDisplayComponent, list::add, tooltipType);
        });
    }

    private static void registerItemProperties() {
        class_10493.field_55421.method_65325((Object)Mishanguc.id("color_mixture_type"), ColorMixtureTypeProperty.TYPE);
        class_10493.field_55421.method_65325((Object)Mishanguc.id("carrying_tool_type"), CarryingToolTypeProperty.TYPE);
        class_10482.field_55408.method_65325((Object)Mishanguc.id("transparency"), TransparencyPropertyProperty.CODEC);
        class_10482.field_55408.method_65325((Object)Mishanguc.id("explosion_power"), ExplosionPowerProperty.CODEC);
        class_10459.field_55372.method_65325((Object)Mishanguc.id("explosion_create_fire"), ExplosionCreateFireProperty.CODEC);
        class_10482.field_55408.method_65325((Object)Mishanguc.id("fast_building_range"), FastBuildingRangeProperty.CODEC);
        class_10402.field_55235.method_65325((Object)Mishanguc.id("color"), ColoredTintSource.CODEC);
    }

    private static void registerNetworking() {
        ClientPlayNetworking.registerGlobalReceiver(EditSignPayload.ID, (payload, context) -> {
            class_2586 blockEntity;
            class_2338 blockPos = payload.blockPos();
            class_310 client = context.client();
            class_2586 class_25862 = blockEntity = client.field_1687 != null ? client.field_1687.method_8321(blockPos) : null;
            if (blockEntity instanceof HungSignBlockEntity) {
                HungSignBlockEntity hungSignBlockEntity = (HungSignBlockEntity)blockEntity;
                class_2350 direction = payload.direction().orElseThrow();
                client.execute(() -> client.method_1507((class_437)new HungSignBlockEditScreen((class_7225.class_7874)client.field_1687.method_30349(), blockPos, direction, hungSignBlockEntity)));
            } else if (blockEntity instanceof WallSignBlockEntity) {
                WallSignBlockEntity wallSignBlockEntity = (WallSignBlockEntity)blockEntity;
                client.execute(() -> client.method_1507((class_437)new WallSignBlockEditScreen((class_7225.class_7874)client.field_1687.method_30349(), wallSignBlockEntity, blockPos)));
            } else if (blockEntity instanceof StandingSignBlockEntity) {
                StandingSignBlockEntity standingSignBlockEntity = (StandingSignBlockEntity)blockEntity;
                class_3965 blockHitResult = payload.blockHitResult().orElseThrow();
                Boolean isFront = StandingSignBlock.getHitSide(blockEntity.method_11010(), blockHitResult);
                if (isFront != null) {
                    client.execute(() -> client.method_1507((class_437)new StandingSignBlockEditScreen((class_7225.class_7874)client.field_1687.method_30349(), standingSignBlockEntity, blockPos, isFront)));
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(GetBlockDataPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new DataTagToolItem.BlockDataReceiver());
        ClientPlayNetworking.registerGlobalReceiver(GetEntityDataPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new DataTagToolItem.EntityDataReceiver());
        ClientPlayNetworking.registerGlobalReceiver(RuleChangedPayload.ID, MishangucRules::handle);
    }

    private static void registerBlockColors() {
        Object[] coloredBlocks = (class_2248[])MishangUtils.blocks().stream().filter(Predicates.instanceOf(ColoredBlock.class)).toArray(class_2248[]::new);
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            class_2586 entity = world.method_8321(pos);
            if (entity == null) {
                entity = world.method_8321(pos.method_10074());
            }
            if (entity instanceof ColoredBlockEntity) {
                ColoredBlockEntity coloredBlockEntity = (ColoredBlockEntity)entity;
                return coloredBlockEntity.getColor();
            }
            int accumulatedNum = 0;
            int accumulatedRed = 0;
            int accumulatedGreen = 0;
            int accumulatedBlue = 0;
            for (class_2338 outPos : class_2338.method_25996((class_2338)pos, (int)1, (int)1, (int)1)) {
                class_2586 patt0$temp;
                if (outPos.equals((Object)pos) || !((patt0$temp = world.method_8321(outPos)) instanceof ColoredBlockEntity)) continue;
                ColoredBlockEntity coloredBlockEntity = (ColoredBlockEntity)patt0$temp;
                int color = coloredBlockEntity.getColor();
                ++accumulatedNum;
                accumulatedRed += color >> 16 & 0xFF;
                accumulatedGreen += color >> 8 & 0xFF;
                accumulatedBlue += color & 0xFF;
            }
            if (accumulatedNum > 0) {
                return (accumulatedRed / accumulatedNum << 16) + (accumulatedGreen / accumulatedNum << 8) + accumulatedBlue / accumulatedNum;
            }
            return -1;
        }, coloredBlocks);
    }

    private static void registerBlockEntityRenderers() {
        class_5616.method_32144(MishangucBlockEntities.HUNG_SIGN_BLOCK_ENTITY, HungSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_HUNG_SIGN_BLOCK_ENTITY, HungSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.FULL_WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.STANDING_SIGN_BLOCK_ENTITY, StandingSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_STANDING_SIGN_BLOCK_ENTITY, StandingSignBlockEntityRenderer::new);
    }

    private static void registerRenderEvents() {
        WorldRenderEvents.BLOCK_OUTLINE.register((Object)RendersBlockOutline.RENDERER);
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((Object)RendersBeforeOutline.RENDERER);
    }

    private static void registerBlockLayers() {
        ((ObjectArrayList)Validate.notEmpty(MishangucBlocks.translucentBlocks)).forEach(block -> BlockRenderLayerMap.putBlock((class_2248)block, (class_11515)class_11515.field_60926));
        ((ObjectArrayList)Validate.notEmpty(MishangucBlocks.cutoutBlocks)).forEach(block -> {
            AbstractRoadBlock roadBlock;
            BlockRenderLayerMap.putBlock((class_2248)block, (class_11515)class_11515.field_60925);
            if (block instanceof AbstractRoadBlock && (roadBlock = (AbstractRoadBlock)block).getRoadSlab() != null) {
                BlockRenderLayerMap.putBlock((class_2248)roadBlock.getRoadSlab(), (class_11515)class_11515.field_60925);
            }
        });
        MishangucBlocks.translucentBlocks = null;
        MishangucBlocks.cutoutBlocks = null;
    }
}

