/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangucClient;
import pers.solid.mishang.uc.networking.RuleChangedPayload;
import pers.solid.mishang.uc.util.TextBridge;

@ApiStatus.AvailableSince(value="1.0.0")
public final class MishangucRules {
    public static final class_1928.class_4313<EnumRule<ToolAccess>> FORCE_PLACING_TOOL_ACCESS = MishangucRules.register("force_placing_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.CREATIVE_ONLY, (server, rule) -> MishangucRules.sync(server, (EnumRule<ToolAccess>)rule, (short)0)));
    public static final class_1928.class_4313<EnumRule<ToolAccess>> CARRYING_TOOL_ACCESS = MishangucRules.register("carrying_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.ALL, (server, rule) -> MishangucRules.sync(server, (EnumRule<ToolAccess>)rule, (short)1)));
    public static final class_1928.class_4313<EnumRule<ToolAccess>> EXPLOSION_TOOL_ACCESS = MishangucRules.register("explosion_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.ALL));

    private static void sync(MinecraftServer server, EnumRule<ToolAccess> rule, short type) {
        for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
            MishangucRules.sync(rule, type, serverPlayerEntity);
        }
    }

    static void sync(EnumRule<ToolAccess> rule, short type, class_3222 serverPlayerEntity) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new RuleChangedPayload(type, (ToolAccess)rule.get()));
    }

    private static <T extends class_1928.class_4315<T>> class_1928.class_4313<T> register(String name, class_1928.class_4314<T> ruleType) {
        return GameRuleRegistry.register((String)("mishanguc:" + name), (class_1928.class_5198)class_1928.class_5198.field_24100, ruleType);
    }

    static void handle(RuleChangedPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            switch (payload.type()) {
                case 0: {
                    MishangucClient.CLIENT_FORCE_PLACING_TOOL_ACCESS.set(payload.toolAccess());
                    break;
                }
                case 1: {
                    MishangucClient.CLIENT_CARRYING_TOOL_ACCESS.set(payload.toolAccess());
                }
            }
        });
    }

    public static enum ToolAccess implements class_3542
    {
        ALL{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return true;
            }
        }
        ,
        CREATIVE_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_68878();
            }
        }
        ,
        OP_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_64475(2);
            }
        }
        ,
        CREATIVE_OP_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_68878() && player.method_64475(2);
            }
        };

        private final String name = this.name().toLowerCase();

        public String method_15434() {
            return this.name;
        }

        @Contract(pure=true)
        public abstract boolean hasAccess(@Nullable class_1657 var1);

        public boolean hasAccess(class_1657 player, boolean warn) {
            boolean hasAccess = this.hasAccess(player);
            if (warn && !hasAccess && !player.method_37908().field_9236) {
                player.method_7353((class_2561)this.createWarnText(), true);
            }
            return hasAccess;
        }

        public class_5250 createWarnText() {
            return TextBridge.translatable("message.tool_access", TextBridge.translatable("message.tool_access." + this.method_15434())).method_27692(class_124.field_1061);
        }
    }
}

