/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10225;
import net.minecraft.class_10795;
import net.minecraft.class_10804;
import net.minecraft.class_10821;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3981;
import net.minecraft.class_4538;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4922;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_5819;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.block.LightConnectable;
import pers.solid.mishang.uc.block.WallLightBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.data.MishangucTextureKeys;

public class AutoConnectWallLightBlock
extends WallLightBlock
implements LightConnectable {
    public static final MapCodec<AutoConnectWallLightBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("light_color").forGetter(b -> b.lightColor), (App)Codec.STRING.fieldOf("shape").forGetter(b -> b.shape), (App)AutoConnectWallLightBlock.method_54096(), (App)Codec.BOOL.fieldOf("large_shape").forGetter(b -> b.largeShape)).apply((Applicative)instance, AutoConnectWallLightBlock::new));
    private static final Map<class_2350, class_265> BASE_SHAPE_PER_FACING = MishangUtils.createDirectionToShape(4.0, 0.0, 4.0, 12.0, 1.0, 12.0);
    private static final Map<class_2350, class_265> SHAPE_PER_DIRECTION_WHEN_FACING_UP = MishangUtils.createHorizontalDirectionToShape(4.0, 0.0, 12.0, 12.0, 1.0, 16.0);
    private static final Map<class_2350, class_265> SHAPE_PER_DIRECTION_WHEN_FACING_DOWN = MishangUtils.createHorizontalDirectionToShape(4.0, 15.0, 4.0, 12.0, 16.0, 12.0);
    private static final List<Map<class_2350, class_265>> SHAPE_PER_DIRECTION_PER_FACING_WHEN_FACING_HORIZONTALLY = ImmutableList.of(MishangUtils.createHorizontalDirectionToShape(4.0, 12.0, 0.0, 12.0, 16.0, 1.0), MishangUtils.createHorizontalDirectionToShape(4.0, 0.0, 0.0, 12.0, 4.0, 1.0), MishangUtils.createHorizontalDirectionToShape(12.0, 4.0, 0.0, 16.0, 12.0, 1.0), MishangUtils.createHorizontalDirectionToShape(0.0, 4.0, 0.0, 4.0, 12.0, 1.0));
    public final String shape;
    private final boolean largeShape;
    final Map<class_2350, class_265> LARGE_SHAPE_PER_DIRECTION = MishangUtils.createDirectionToShape(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public AutoConnectWallLightBlock(String lightColor, String shape, class_4970.class_2251 settings, boolean largeShape) {
        super(lightColor, settings, false);
        this.shape = shape;
        this.largeShape = largeShape;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WEST, EAST, SOUTH, NORTH, UP, DOWN});
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2338 neighborPos2;
        class_2680 neighborState2;
        class_2248 neighborBlock2;
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        class_2680 newState = super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2248 neighborBlock = neighborState.method_26204();
        boolean connect = false;
        if (neighborBlock instanceof LightConnectable) {
            LightConnectable lightConnectable = (LightConnectable)neighborBlock;
            connect = lightConnectable.isConnectedIn(neighborState, facing, direction.method_10153());
        }
        if ((neighborBlock2 = (neighborState2 = world.method_8320(neighborPos2 = pos.method_10093(direction).method_10093(facing.method_10153()))).method_26204()) instanceof LightConnectable) {
            LightConnectable lightConnectable = (LightConnectable)neighborBlock2;
            connect = connect || lightConnectable.isConnectedIn(neighborState2, direction, facing);
        }
        return (class_2680)newState.method_11657((class_2769)DIRECTION_TO_PROPERTY.get((Object)direction), (Comparable)Boolean.valueOf(connect));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 placementState = super.method_9605(ctx);
        if (placementState == null) {
            return null;
        }
        class_2350 facing = (class_2350)placementState.method_11654((class_2769)field_10927);
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166() == facing.method_10166()) continue;
            class_2338 blockPos = ctx.method_8037();
            class_1937 world = ctx.method_8045();
            class_2338 offsetBlockPos = blockPos.method_10093(direction);
            placementState = this.method_9559(placementState, (class_4538)world, (class_10225)world, blockPos, direction, offsetBlockPos, world.method_8320(offsetBlockPos), world.method_8409());
        }
        return placementState;
    }

    @Override
    public boolean isConnectedIn(class_2680 blockState, class_2350 facing, class_2350 direction) {
        return blockState.method_11654((class_2769)field_10927) == facing;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        if (this.largeShape) {
            return this.LARGE_SHAPE_PER_DIRECTION.get(facing);
        }
        class_265 baseShape = BASE_SHAPE_PER_FACING.get(facing);
        return class_259.method_17786((class_265)baseShape, (class_265[])(switch (facing) {
            case class_2350.field_11036 -> (class_265[])Arrays.stream(class_2350.values()).filter(direction -> (Boolean)state.method_11654((class_2769)DIRECTION_TO_PROPERTY.get(direction))).map(SHAPE_PER_DIRECTION_WHEN_FACING_UP::get).filter(Objects::nonNull).toArray(class_265[]::new);
            case class_2350.field_11033 -> (class_265[])Arrays.stream(class_2350.values()).filter(direction -> (Boolean)state.method_11654((class_2769)DIRECTION_TO_PROPERTY.get(direction))).map(SHAPE_PER_DIRECTION_WHEN_FACING_DOWN::get).filter(Objects::nonNull).toArray(class_265[]::new);
            default -> {
                ArrayList<class_265> voxelShapeList = new ArrayList<class_265>();
                if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
                    voxelShapeList.add(SHAPE_PER_DIRECTION_PER_FACING_WHEN_FACING_HORIZONTALLY.get(0).get(facing));
                }
                if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                    voxelShapeList.add(SHAPE_PER_DIRECTION_PER_FACING_WHEN_FACING_HORIZONTALLY.get(1).get(facing));
                }
                if (((Boolean)state.method_11654((class_2769)DIRECTION_TO_PROPERTY.get((Object)facing.method_10160()))).booleanValue()) {
                    voxelShapeList.add(SHAPE_PER_DIRECTION_PER_FACING_WHEN_FACING_HORIZONTALLY.get(2).get(facing));
                }
                if (((Boolean)state.method_11654((class_2769)DIRECTION_TO_PROPERTY.get((Object)facing.method_10170()))).booleanValue()) {
                    voxelShapeList.add(SHAPE_PER_DIRECTION_PER_FACING_WHEN_FACING_HORIZONTALLY.get(3).get(facing));
                }
                yield voxelShapeList.toArray(new class_265[0]);
            }
        }));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textureMap = class_4944.method_25883((class_4945)MishangucTextureKeys.LIGHT, (class_2960)MishangucModels.texture(this.lightColor + "_light"));
        class_2960 modelId = MishangucModels.createBlock("wall_light_%s_decoration".formatted(this.shape), MishangucTextureKeys.LIGHT).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
        class_2960 centerModelId = MishangucModels.createBlock("wall_light_%s_decoration_center".formatted(this.shape), "_center", MishangucTextureKeys.LIGHT).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
        class_2960 connectionModelId = MishangucModels.createBlock("wall_light_%s_decoration_connection".formatted(this.shape), "_connection", MishangucTextureKeys.LIGHT).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
        class_2960 connection2ModelId = MishangucModels.createBlock("wall_light_%s_decoration_connection2".formatted(this.shape), "_connection2", MishangucTextureKeys.LIGHT).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25623((class_2248)this, modelId);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)this);
        for (class_2350 facing : class_2350.values()) {
            class_807 class_8072 = class_4910.method_67835((class_2960)centerModelId);
            class_807 central = class_8072.method_67929(class_10804.field_56937.withValue((Object)(switch (facing) {
                case class_2350.field_11034 -> class_10821.field_57030;
                case class_2350.field_11035 -> class_10821.field_57031;
                case class_2350.field_11039 -> class_10821.field_57032;
                default -> class_10821.field_57029;
            }))).method_67929(class_10804.field_56936.withValue((Object)(facing == class_2350.field_11033 ? class_10821.field_57031 : (facing == class_2350.field_11036 ? class_10821.field_57029 : class_10821.field_57030))));
            blockStateSupplier.method_25762(class_4910.method_67834().method_67847((class_2769)field_10927, (Comparable)facing), central);
            for (class_2350 direction : class_2350.values()) {
                int y;
                class_10821 x;
                class_2960 modelName;
                class_2350.class_2351 axis = direction.method_10166();
                if (axis == facing.method_10166()) continue;
                if (facing == class_2350.field_11036) {
                    modelName = connectionModelId;
                    x = class_10821.field_57029;
                    y = (int)direction.method_10144();
                } else if (facing == class_2350.field_11033) {
                    modelName = connectionModelId;
                    x = class_10821.field_57031;
                    y = (int)direction.method_10144() + 180;
                } else if (direction == class_2350.field_11036) {
                    modelName = connectionModelId;
                    x = class_10821.field_57030;
                    y = (int)facing.method_10144() + 180;
                } else if (direction == class_2350.field_11033) {
                    modelName = connectionModelId;
                    x = class_10821.field_57032;
                    y = (int)facing.method_10144();
                } else if (direction == facing.method_10160()) {
                    modelName = connection2ModelId;
                    x = class_10821.field_57029;
                    y = (int)facing.method_10144();
                } else if (direction == facing.method_10170()) {
                    modelName = connection2ModelId;
                    x = class_10821.field_57031;
                    y = (int)facing.method_10144() + 180;
                } else {
                    Mishanguc.MISHANG_LOGGER.error("Unknown state to generate models: facing={},direction={}", (Object)facing.method_15434(), (Object)direction.method_15434());
                    continue;
                }
                class_10795 class_107952 = class_4910.method_67834().method_67847((class_2769)field_10927, (Comparable)facing).method_67847((class_2769)DIRECTION_TO_PROPERTY.get((Object)direction), (Comparable)Boolean.valueOf(true));
                class_807 class_8073 = class_4910.method_67835((class_2960)modelName).method_67929(class_10804.field_56936.withValue((Object)x));
                blockStateSupplier.method_25762(class_107952, class_8073.method_67929(class_10804.field_56937.withValue((Object)(switch (class_3532.method_15387((int)y, (int)360)) {
                    case 90 -> class_10821.field_57030;
                    case 180 -> class_10821.field_57031;
                    case 270 -> class_10821.field_57032;
                    default -> class_10821.field_57029;
                }))));
            }
        }
        blockStateModelGenerator.field_22830.accept(blockStateSupplier);
    }

    protected MapCodec<? extends AutoConnectWallLightBlock> method_53969() {
        return CODEC;
    }

    @Override
    public class_5797 getCraftingRecipe(class_2446 recipeGenerator) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)this.method_8389());
        @NotNull class_1792 fullLight = WallLightBlock.getBaseLight(itemId.method_12836(), this.lightColor, (class_2248)this);
        String path = itemId.method_12832();
        int outputCount = path.contains("_round_") ? 9 : (path.contains("_point_") ? 18 : (path.contains("_simple_") ? 15 : 12));
        return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{fullLight}), (class_7800)class_7800.field_40635, (class_1935)this, (int)outputCount).method_17970(class_2446.method_32807((class_1935)fullLight), recipeGenerator.method_10426((class_1935)fullLight));
    }
}

