/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3981;
import net.minecraft.class_4538;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_5819;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.ColumnWallLightBlock;
import pers.solid.mishang.uc.block.MishangucBlock;
import pers.solid.mishang.uc.block.WallLightBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.data.MishangucTextureKeys;

public class ColumnLightBlock
extends class_2248
implements class_3737,
MishangucBlock {
    public static final MapCodec<ColumnLightBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("light_color").forGetter(block -> block.lightColor), (App)ColumnLightBlock.method_54096(), (App)Codec.INT.fieldOf("size_type").forGetter(block -> block.sizeType)).apply((Applicative)instance, ColumnLightBlock::new));
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    public final String lightColor;
    private final int sizeType;

    public ColumnLightBlock(String lightColor, class_4970.class_2251 settings, int sizeType) {
        super(settings);
        this.lightColor = lightColor;
        this.sizeType = sizeType;
        this.method_9590((class_2680)this.method_9564().method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AXIS, class_2741.field_12508});
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)super.method_9598(state, rotation).method_11657(AXIS, (Comparable)MishangUtils.rotateAxis(rotation, (class_2350.class_2351)state.method_11654(AXIS)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos;
        class_2350 direction = ctx.method_8038();
        class_1937 world = ctx.method_8045();
        class_2680 blockState = world.method_8320((blockPos = ctx.method_8037()).method_10093(direction.method_10153()));
        if (blockState.method_26222((class_1922)world, blockPos).method_20538(direction).method_1110() && blockState.method_26218((class_1922)world, blockPos).method_20538(direction).method_1110()) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)direction.method_10166())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_8320(blockPos).method_26227().method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (this.sizeType >= 2 ? ColumnWallLightBlock.SHAPES4 : (this.sizeType == 1 ? ColumnWallLightBlock.SHAPES5 : ColumnWallLightBlock.SHAPES6)).get(state.method_11654(AXIS));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (this.sizeType >= 2 ? ColumnWallLightBlock.SHAPES5 : (this.sizeType == 1 ? ColumnWallLightBlock.SHAPES6 : ColumnWallLightBlock.SHAPES7)).get(state.method_11654(AXIS));
    }

    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        return stateFrom.method_27852((class_2248)this) && ((class_2350.class_2351)state.method_11654(AXIS)).method_10176(direction) && ((class_2350.class_2351)stateFrom.method_11654(AXIS)).method_10176(direction) || super.method_9522(state, stateFrom, direction);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textures = class_4944.method_25883((class_4945)MishangucTextureKeys.LIGHT, (class_2960)MishangucModels.texture(this.lightColor + "_light"));
        class_2960 modelId = this.getModelType().method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4925.method_67853((class_2248)this, (class_807)class_4910.method_67835((class_2960)modelId)).method_25775((class_4926)class_4926.method_67869(AXIS).method_25794((Comparable)class_2350.class_2351.field_11052, (Object)class_4910.field_56780).method_25794((Comparable)class_2350.class_2351.field_11048, (Object)class_4910.field_56784.then(class_4910.field_56785)).method_25794((Comparable)class_2350.class_2351.field_11051, (Object)class_4910.field_56784)));
        blockStateModelGenerator.method_25623((class_2248)this, modelId);
    }

    public class_4942 getModelType() {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)this);
        String path = identifier.method_12832();
        int i = this.lightColor.length();
        if (!path.startsWith(this.lightColor) || path.charAt(i) != '_') {
            throw new AssertionError();
        }
        path = path.substring(i + 1);
        return MishangucModels.createBlock(path, MishangucTextureKeys.LIGHT);
    }

    @Override
    public class_5797 getCraftingRecipe(class_2446 recipeGenerator) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)this.method_8389());
        String itemPath = itemId.method_12832();
        if (itemPath.endsWith("_tube")) {
            int outputCount;
            @NotNull class_1792 fullLight = WallLightBlock.getBaseLight(itemId.method_12836(), this.lightColor, this);
            if (itemPath.contains("_thin_")) {
                outputCount = 32;
            } else if (itemPath.contains("_medium_")) {
                outputCount = 16;
            } else if (itemPath.contains("thick")) {
                outputCount = 8;
            } else {
                throw new IllegalStateException(String.format("Can't generate recipes: Cannot determine the type of %s according to its id", this));
            }
            return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{fullLight}), (class_7800)class_7800.field_40635, (class_1935)this, (int)outputCount).method_17970(class_2446.method_32807((class_1935)fullLight), recipeGenerator.method_10426((class_1935)fullLight));
        }
        class_2960 tubeId = itemId.method_48331("_tube");
        @NotNull class_1792 tube = (class_1792)class_7923.field_41178.method_17966(tubeId).orElseThrow(() -> new IllegalArgumentException(String.format("Can't generate recipes: %s does not have a corresponding tube block (with id [%s])", this, tubeId)));
        return recipeGenerator.method_62750(class_7800.field_40635, (class_1935)this, 1).method_10454((class_1935)tube).method_10454((class_1935)class_1802.field_8333).method_10442(class_2446.method_32807((class_1935)tube), recipeGenerator.method_10426((class_1935)tube));
    }

    protected MapCodec<? extends ColumnLightBlock> method_53969() {
        return CODEC;
    }

    @Override
    public String customRecipeCategory() {
        return "light";
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}

