/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10401;
import net.minecraft.class_10410;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.block.HandrailCentralBlock;
import pers.solid.mishang.uc.block.HandrailCornerBlock;
import pers.solid.mishang.uc.block.HandrailOuterBlock;
import pers.solid.mishang.uc.block.HandrailStairBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.item.ColoredTintSource;
import pers.solid.mishang.uc.util.TextBridge;

@ApiStatus.AvailableSince(value="0.2.4")
public class GlassHandrailBlock
extends HandrailBlock {
    public static final MapCodec<GlassHandrailBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_block").forGetter(GlassHandrailBlock::baseBlock), (App)GlassHandrailBlock.method_54096()).apply((Applicative)instance, (block, settings1) -> new GlassHandrailBlock((class_2248)block, (class_4970.class_2251)settings1, null, null, class_7923.field_41175.method_10221(block), false)));
    public final class_2960 decorationTexture;
    private final CentralBlock central;
    private final CornerBlock corner;
    private final StairBlock stair;
    private final OuterBlock outer;
    private final class_2248 baseBlock;
    private final class_2960 frameTexture;

    public GlassHandrailBlock(class_2248 baseBlock, class_4970.class_2251 settings, String frameTexture, String decorationTexture, class_2960 identifier) {
        this(baseBlock, settings, frameTexture, decorationTexture, identifier, true);
    }

    protected GlassHandrailBlock(class_2248 baseBlock, class_4970.class_2251 settings, String frameTexture, String decorationTexture, class_2960 identifier, boolean createAffiliateBlocks) {
        super(settings.method_22488().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier)));
        this.baseBlock = baseBlock;
        this.frameTexture = frameTexture == null ? null : class_2960.method_60654((String)frameTexture);
        this.decorationTexture = decorationTexture == null ? null : class_2960.method_60654((String)decorationTexture);
        this.central = createAffiliateBlocks ? new CentralBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_central")))) : null;
        this.corner = createAffiliateBlocks ? new CornerBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_corner")))) : null;
        this.stair = createAffiliateBlocks ? new StairBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_stair")))) : null;
        this.outer = createAffiliateBlocks ? new OuterBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_outer")))) : null;
    }

    protected GlassHandrailBlock(class_2248 baseBlock, class_4970.class_2251 settings, String frameTexture, String decorationTexture, BiFunction<GlassHandrailBlock, class_4970.class_2251, CentralBlock> centralProvider, BiFunction<GlassHandrailBlock, class_4970.class_2251, CornerBlock> cornerProvider, BiFunction<GlassHandrailBlock, class_4970.class_2251, StairBlock> stairProvider, BiFunction<GlassHandrailBlock, class_4970.class_2251, OuterBlock> outerProvider, class_2960 identifier) {
        super(settings.method_22488().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier)));
        this.baseBlock = baseBlock;
        this.frameTexture = class_2960.method_60654((String)frameTexture);
        this.decorationTexture = class_2960.method_60654((String)decorationTexture);
        this.central = centralProvider.apply(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_central"))));
        this.corner = cornerProvider.apply(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_corner"))));
        this.stair = stairProvider.apply(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_stair"))));
        this.outer = outerProvider.apply(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_outer"))));
    }

    protected static <B extends class_2248> MapCodec<B> createSubCodec(Function<B, GlassHandrailBlock> baseGetter, BiFunction<GlassHandrailBlock, class_4970.class_2251, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_rail").flatXmap(block -> {
            DataResult dataResult;
            if (block instanceof GlassHandrailBlock) {
                GlassHandrailBlock glassHandrailBlock = (GlassHandrailBlock)block;
                dataResult = DataResult.success((Object)glassHandrailBlock);
            } else {
                dataResult = DataResult.error(() -> String.valueOf(block) + " not instance of " + GlassHandrailBlock.class.getName());
            }
            return dataResult;
        }, DataResult::success).forGetter(baseGetter), (App)GlassHandrailBlock.method_54096()).apply((Applicative)instance, function));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textures = this.getTextures();
        class_2960 modelId = MishangucModels.GLASS_HANDRAIL.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
        class_2960 itemModelId = MishangucModels.GLASS_HANDRAIL_INVENTORY.method_25852(class_4941.method_25840((class_1792)this.method_8389()), textures, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        if (this instanceof ColoredBlock) {
            blockStateModelGenerator.field_55238.method_65460(this.method_8389(), class_10410.method_65483((class_2960)itemModelId, (class_10401[])new class_10401[]{ColoredTintSource.INSTANCE}));
        } else {
            blockStateModelGenerator.field_55238.method_65460(this.method_8389(), class_10410.method_65481((class_2960)itemModelId));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @NotNull
    public class_4944 getTextures() {
        return new class_4944().method_25868(TextureKeys.FRAME, this.frameTexture).method_25868(TextureKeys.GLASS, Mishanguc.id("block/glass_unframed")).method_25868(TextureKeys.DECORATION, this.decorationTexture);
    }

    @Override
    public HandrailCentralBlock<? extends HandrailBlock> central() {
        return this.central;
    }

    @Override
    public HandrailCornerBlock<? extends HandrailBlock> corner() {
        return this.corner;
    }

    @Override
    public HandrailStairBlock<? extends HandrailBlock> stair() {
        return this.stair;
    }

    @Override
    public HandrailOuterBlock<? extends HandrailBlock> outer() {
        return this.outer;
    }

    @Override
    @Nullable
    public class_2248 baseBlock() {
        return this.baseBlock;
    }

    protected MapCodec<? extends GlassHandrailBlock> method_53969() {
        return CODEC;
    }

    public static class CentralBlock
    extends HandrailCentralBlock<GlassHandrailBlock> {
        public static final MapCodec<CentralBlock> CODEC = GlassHandrailBlock.createSubCodec(b -> (GlassHandrailBlock)b.baseHandrail, CentralBlock::new);

        protected CentralBlock(@NotNull GlassHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_central", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((GlassHandrailBlock)this.baseHandrail).getTextures();
            class_2960 postModelId = MishangucModels.GLASS_HANDRAIL_POST.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            class_2960 sideModelId = MishangucModels.GLASS_HANDRAIL_SIDE.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            class_2960 postSideModelId = MishangucModels.GLASS_HANDRAIL_POST_SIDE.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(postModelId, postSideModelId, sideModelId));
        }

        @Override
        protected MapCodec<? extends CentralBlock> method_53969() {
            return CODEC;
        }
    }

    public static class CornerBlock
    extends HandrailCornerBlock<GlassHandrailBlock> {
        public static final MapCodec<CornerBlock> CODEC = GlassHandrailBlock.createSubCodec(b -> (GlassHandrailBlock)b.baseHandrail, CornerBlock::new);

        protected CornerBlock(@NotNull GlassHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_corner", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.GLASS_HANDRAIL_CORNER.method_25846((class_2248)this, ((GlassHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        @Override
        protected MapCodec<? extends CornerBlock> method_53969() {
            return CODEC;
        }
    }

    public static class StairBlock
    extends HandrailStairBlock<GlassHandrailBlock> {
        public static final MapCodec<StairBlock> CODEC = GlassHandrailBlock.createSubCodec(b -> (GlassHandrailBlock)b.baseHandrail, StairBlock::new);

        protected StairBlock(@NotNull GlassHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        @Override
        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_stair", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((GlassHandrailBlock)this.baseHandrail).getTextures();
            class_2960 baseModelId = MishangucModels.createBlock("glass_handrail_stair_middle_center", TextureKeys.FRAME, TextureKeys.GLASS, TextureKeys.DECORATION).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            for (HandrailStairBlock.Shape shape : HandrailStairBlock.Shape.values()) {
                for (HandrailStairBlock.Position position : HandrailStairBlock.Position.values()) {
                    MishangucModels.createBlock(String.format("glass_handrail_stair_%s_%s", shape.method_15434(), position.method_15434()), "_" + shape.method_15434() + "_" + position.method_15434(), TextureKeys.FRAME, TextureKeys.GLASS, TextureKeys.DECORATION).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
                }
            }
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(baseModelId));
        }

        @Override
        protected MapCodec<? extends StairBlock> method_53969() {
            return CODEC;
        }
    }

    public static class OuterBlock
    extends HandrailOuterBlock<GlassHandrailBlock> {
        public static final MapCodec<OuterBlock> CODEC = GlassHandrailBlock.createSubCodec(b -> (GlassHandrailBlock)b.baseHandrail, OuterBlock::new);

        protected OuterBlock(@NotNull GlassHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_outer", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.GLASS_HANDRAIL_OUTER.method_25846((class_2248)this, ((GlassHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        @Override
        protected MapCodec<? extends OuterBlock> method_53969() {
            return CODEC;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextureKeys {
        public static final class_4945 FRAME = class_4945.method_27043((String)"frame");
        public static final class_4945 GLASS = class_4945.method_27043((String)"glass");
        public static final class_4945 DECORATION = class_4945.method_27043((String)"decoration");

        private TextureKeys() {
        }
    }
}

