/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2510;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_813;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import pers.solid.mishang.uc.MishangucProperties;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.block.Handrails;
import pers.solid.mishang.uc.block.MishangucBlock;
import pers.solid.mishang.uc.mixin.BlockStateModelGeneratorAccessor;
import pers.solid.mishang.uc.util.TextBridge;

public abstract class HandrailStairBlock<T extends HandrailBlock>
extends class_2383
implements class_3737,
MishangucBlock,
Handrails {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<Position> POSITION = MishangucProperties.HANDRAIL_STAIR_POSITION;
    public static final class_2754<Shape> SHAPE = MishangucProperties.HANDRAIL_STAIR_SHAPE;
    @NotNull
    public final T baseHandrail;
    public static final @Unmodifiable Map<class_2350, Map<Position, Map<Shape, class_265>>> SHAPES = Maps.toMap((Iterator)class_2350.class_2353.field_11062.iterator(), facing -> Maps.toMap((Iterator)Iterators.forArray((Object[])Position.values()), position -> Maps.toMap((Iterator)Iterators.forArray((Object[])Shape.values()), shape -> HandrailStairBlock.composeShape(facing, position, shape))));

    protected HandrailStairBlock(@NotNull T baseHandrail, class_4970.class_2251 settings) {
        super(settings);
        this.baseHandrail = baseHandrail;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(POSITION, (Comparable)((Object)Position.CENTER))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11035)).method_11657(SHAPE, (Comparable)((Object)Shape.MIDDLE)));
    }

    public HandrailStairBlock(@NotNull T baseHandrail) {
        this(baseHandrail, class_4970.class_2251.method_9630(baseHandrail));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED, POSITION, field_11177, SHAPE});
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public class_4917 createBlockStates(class_2960 modelId) {
        return class_4925.method_67852((class_2248)this).method_67859(class_4926.method_67865(POSITION, SHAPE).method_25800((position, shape) -> class_4910.method_67822((class_813)class_4910.method_67806((class_2960)modelId.method_48331("_" + shape.method_15434() + "_" + position.method_15434()))))).method_67856(class_4910.field_56781).method_25775(BlockStateModelGeneratorAccessor.getNORTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS());
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        Shape shape;
        class_2350 facing;
        class_2680 placementState = super.method_9605(ctx);
        if (placementState == null) {
            return null;
        }
        class_2338 blockPos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        class_2680 stateBelow = world.method_8320(blockPos.method_10074());
        if (stateBelow.method_26204() instanceof class_2510 && stateBelow.method_28498((class_2769)class_2510.field_11571) && stateBelow.method_28498((class_2769)class_2510.field_11572) && stateBelow.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617) {
            facing = (class_2350)stateBelow.method_11654((class_2769)class_2510.field_11571);
            class_2338 forwardPos = blockPos.method_10093(facing);
            class_2680 forwardState = world.method_8320(forwardPos);
            shape = forwardState.method_26204() instanceof class_2510 && forwardState.method_28498((class_2769)class_2510.field_11572) && forwardState.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617 && forwardState.method_28498((class_2769)class_2510.field_11571) && forwardState.method_11654((class_2769)class_2510.field_11571) == facing ? Shape.MIDDLE : Shape.TOP;
        } else {
            facing = ctx.method_8042();
            shape = Shape.BOTTOM;
        }
        class_243 hitPos = ctx.method_17698();
        double diff = switch (facing) {
            case class_2350.field_11035 -> hitPos.field_1352 - (double)blockPos.method_10263();
            case class_2350.field_11043 -> (double)(blockPos.method_10263() + 1) - hitPos.field_1352;
            case class_2350.field_11034 -> (double)(blockPos.method_10260() + 1) - hitPos.field_1350;
            case class_2350.field_11039 -> hitPos.field_1350 - (double)blockPos.method_10260();
            default -> 0.5;
        };
        return (class_2680)((class_2680)((class_2680)((class_2680)placementState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(blockPos).method_15772() == class_3612.field_15910))).method_11657((class_2769)field_11177, (Comparable)facing)).method_11657(POSITION, (Comparable)((Object)(diff < 0.3 ? Position.RIGHT : (diff < 0.7 ? Position.CENTER : Position.LEFT))))).method_11657(SHAPE, (Comparable)((Object)shape));
    }

    @Nullable
    protected static class_2350 equivalentFacing(class_2350 facing, Position position) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> facing.method_10170();
            case 2 -> facing.method_10160();
            case 1 -> null;
        };
    }

    @Nullable
    public static class_2350 equivalentFacing(class_2680 state) {
        return HandrailStairBlock.equivalentFacing((class_2350)state.method_11654((class_2769)field_11177), (Position)((Object)state.method_11654(POSITION)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        Position type = (Position)((Object)state.method_11654(POSITION));
        Shape shape = (Shape)((Object)state.method_11654(SHAPE));
        return SHAPES.get(facing).get((Object)type).get((Object)shape);
    }

    private static class_265 composeShape(class_2350 facing, Position position, Shape shape) {
        int i;
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        class_243 forwardUnit = class_243.method_24954((class_2382)facing.method_62675());
        class_243 rightUnit = class_243.method_24954((class_2382)facing.method_10170().method_62675());
        new class_243(0.5, 0.0, 0.5).method_1019(forwardUnit.method_1021(0.5));
        class_243 basePoint = new class_243(0.5, 0.0, 0.5).method_1019(forwardUnit.method_1021(0.5));
        switch (position.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                class_243 class_2432 = basePoint.method_1019(rightUnit.method_1021(-0.46875));
                break;
            }
            case 1: {
                class_243 class_2432 = basePoint.method_1019(rightUnit.method_1021(-0.0625));
                break;
            }
            case 2: {
                class_243 class_2432 = basePoint = basePoint.method_1019(rightUnit.method_1021(0.34375));
            }
        }
        if (shape == Shape.TOP) {
            shapes.add(class_259.method_1078((class_238)new class_238(basePoint, basePoint.method_1031(0.0, 1.0, 0.0).method_1019(forwardUnit.method_1021(-0.5)).method_1019(rightUnit.method_1021(0.125)))));
            basePoint = basePoint.method_1019(forwardUnit.method_1021(-0.5));
        } else {
            for (i = 0; i < 8; ++i) {
                shapes.add(class_259.method_1078((class_238)new class_238(basePoint, basePoint.method_1031(0.0, (double)(24 - i) / 16.0, 0.0).method_1019(forwardUnit.method_1021(-0.0625)).method_1019(rightUnit.method_1021(0.125)))));
                basePoint = basePoint.method_1019(forwardUnit.method_1021(-0.0625));
            }
        }
        basePoint = basePoint.method_1031(0.0, -0.5, 0.0);
        if (shape == Shape.BOTTOM) {
            basePoint = basePoint.method_1031(0.0, 0.5, 0.0);
            shapes.add(class_259.method_1078((class_238)new class_238(basePoint, basePoint.method_1031(0.0, 1.0, 0.0).method_1019(forwardUnit.method_1021(-0.5)).method_1019(rightUnit.method_1021(0.125)))));
        } else {
            for (i = 0; i < 8; ++i) {
                shapes.add(class_259.method_1078((class_238)new class_238(basePoint, basePoint.method_1031(0.0, (double)(24 - i) / 16.0, 0.0).method_1019(forwardUnit.method_1021(-0.0625)).method_1019(rightUnit.method_1021(0.125)))));
                basePoint = basePoint.method_1019(forwardUnit.method_1021(-0.0625));
            }
        }
        return class_259.method_17786((class_265)class_259.method_1073(), (class_265[])shapes.toArray(new class_265[0]));
    }

    public class_1792 method_8389() {
        return this.baseHandrail.method_8389();
    }

    @Override
    @Nullable
    public class_2248 baseBlock() {
        return ((HandrailBlock)this.baseHandrail).baseBlock();
    }

    @Override
    public boolean connectsIn(@NotNull class_2680 blockState, @NotNull class_2350 direction, @Nullable class_2350 offsetFacing) {
        return offsetFacing == HandrailStairBlock.equivalentFacing(blockState) && (blockState.method_11654((class_2769)field_11177) == direction && blockState.method_11654(SHAPE) == Shape.TOP || blockState.method_11654((class_2769)field_11177) == direction.method_10153() && blockState.method_11654(SHAPE) == Shape.BOTTOM);
    }

    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        class_2248 block = stateFrom.method_26204();
        if (block instanceof Handrails) {
            Handrails handrails = (Handrails)block;
            return handrails.connectsIn(stateFrom, direction.method_10153(), HandrailStairBlock.equivalentFacing(state)) && block.method_8389() == this.method_8389();
        }
        return super.method_9522(state, stateFrom, direction);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        class_2350 mirrored = mirror.method_10343(facing);
        return (class_2680)((class_2680)super.method_9569(state, mirror).method_11657((class_2769)field_11177, (Comparable)mirrored)).method_11657(POSITION, (Comparable)((Object)((Position)((Object)state.method_11654(POSITION))).swap()));
    }

    public class_5250 method_9518() {
        class_2248 block = this.baseBlock();
        return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.handrail_stair", block.method_9518());
    }

    protected abstract MapCodec<? extends HandrailStairBlock<?>> method_53969();

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public static enum Position implements class_3542
    {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        public static final class_3542.class_7292<Position> CODEC;
        private final String name;

        private Position(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public Position swap() {
            return switch (this.ordinal()) {
                case 0 -> RIGHT;
                case 2 -> LEFT;
                default -> this;
            };
        }

        static {
            CODEC = class_3542.method_28140(Position::values);
        }
    }

    public static enum Shape implements class_3542
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        public static final class_3542.class_7292<Shape> CODEC;
        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Shape::values);
        }
    }
}

