/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3965;
import net.minecraft.class_9904;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithAutoLine
extends Road {
    public class_2680 makeState(EnumMap<class_2350, RoadConnectionState> var1, class_2680 var2);

    default public class_2680 tryMakeState(EnumMap<class_2350, RoadConnectionState> connectionStateMap, class_2680 defaultState, class_2338 pos) {
        try {
            return this.makeState(connectionStateMap, defaultState);
        }
        catch (Throwable throwable) {
            Mishanguc.MISHANG_LOGGER.error("An error was found when converting road block at {}:", (Object)pos, (Object)throwable);
            return defaultState;
        }
    }

    default public EnumMap<class_2350, @NotNull RoadConnectionState> getConnectionStateMap(class_1936 world, class_2338 pos0) {
        EnumMap<class_2350, @NotNull RoadConnectionState> connectionStateMap = new EnumMap<class_2350, RoadConnectionState>(class_2350.class);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            RoadConnectionState state = null;
            for (class_2338 pos : new class_2338[]{pos0, pos0.method_10084(), pos0.method_10074()}) {
                class_2680 nextState = world.method_8320(pos.method_10079(direction, 1));
                class_2248 nextBlock = nextState.method_26204();
                if (!(nextBlock instanceof Road)) continue;
                Road road = (Road)nextBlock;
                state = road.getConnectionStateOf(nextState, direction.method_10153());
                break;
            }
            connectionStateMap.put(direction, (RoadConnectionState)ObjectUtils.getIfNull(state, RoadConnectionState::empty));
        }
        return connectionStateMap;
    }

    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return Road.super.getConnectionStateOf(state, direction).or(new RoadConnectionState(RoadConnectionState.WhetherConnected.MAY_CONNECT, this.getLineColor(state, direction), EightHorizontalDirection.of(direction), LineType.NORMAL));
    }

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        Road.super.appendRoadProperties(builder);
    }

    @Override
    default public class_1269 onUseRoad(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        world.method_8652(pos, this.tryMakeState(this.getConnectionStateMap((class_1936)world, pos), state, pos), 2);
        return class_1269.field_5812;
    }

    @Override
    default public class_1269 onUseRoadWithItem(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1747 blockItem;
        class_1792 item = player.method_5998(hand).method_7909();
        if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof RoadWithAutoLine && !class_2350.class_2353.field_11064.method_10182(hit.method_17780())) {
            return class_1269.field_5811;
        }
        return class_1269.field_52423;
    }

    @Override
    default public void neighborRoadUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (wireOrientation == null || !wireOrientation.method_61849().method_10166().method_10178()) {
            world.method_8652(pos, this.tryMakeState(this.getConnectionStateMap((class_1936)world, pos), state, pos), 2);
        }
        Road.super.neighborRoadUpdate(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        Road.super.appendRoadTooltip(stack, context, tooltip, options);
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_auto_line.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_auto_line.2").method_27692(class_124.field_1080));
    }

    public static enum RoadAutoLineType {
        RIGHT_ANGLE,
        BEVEL;

        public static final Codec<RoadAutoLineType> CODEC;

        static {
            CODEC = Codec.BOOL.xmap(b -> b != false ? BEVEL : RIGHT_ANGLE, e -> e == BEVEL);
        }
    }
}

