/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_807;
import net.minecraft.class_813;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithCrossLine
extends Road {
    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return Road.super.getConnectionStateOf(state, direction).or(new RoadConnectionState(RoadConnectionState.WhetherConnected.CONNECTED, this.getLineColor(state, direction), EightHorizontalDirection.of(direction), LineType.NORMAL));
    }

    public static class Impl
    extends AbstractRoadBlock
    implements RoadWithCrossLine {
        public static final MapCodec<Impl> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Impl.method_54096(), Impl.lineColorFieldCodec()).apply((Applicative)i, Impl::new));

        public Impl(class_4970.class_2251 settings, LineColor lineColor) {
            super(settings, lineColor, LineType.NORMAL);
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.cross.composed", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineSide(MishangUtils.composeStraightLineTexture(this.lineColor, LineType.NORMAL)).lineTop(this.lineColor.method_15434() + "_cross_line");
            class_2960 modelId = ((Road)road).uploadModel("_with_cross_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_TOP);
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_67853(road, (class_807)class_4910.method_67839((class_813)class_4910.method_67806((class_2960)modelId)))));
        }

        protected MapCodec<? extends Impl> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            return recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 4).method_10439("*X*").method_10439("X*X").method_10439("*X*").method_10433(Character.valueOf('*'), this.lineColor.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base).method_10429("has_ingredient", recipeGenerator.method_10420(this.lineColor.getIngredient())).method_10429(class_2446.method_32807((class_1935)base), recipeGenerator.method_10426((class_1935)base));
        }
    }
}

