/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10804;
import net.minecraft.class_10821;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.block.RoadWithAngleLine;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithDiffAngleLine
extends RoadWithAngleLine {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        RoadWithAngleLine.super.appendRoadProperties(builder);
        builder.method_11667(new class_2769[]{AXIS});
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        return (class_2680)RoadWithAngleLine.super.rotateRoad(state, rotation).method_11657(AXIS, (Comparable)MishangUtils.rotateAxis(rotation, (class_2350.class_2351)state.method_11654(AXIS)));
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        return (class_2680)RoadWithAngleLine.super.withPlacementState(state, ctx).method_11657(AXIS, (Comparable)ctx.method_8042().method_10166());
    }

    public static class Impl
    extends RoadWithAngleLine.Impl
    implements RoadWithDiffAngleLine {
        public static final MapCodec<Impl> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Impl.method_54096(), Impl.lineColorFieldCodec(), (App)LineColor.CODEC.fieldOf("line_color2").forGetter(b -> b.lineColor2), Impl.lineTypeFieldCodec(), (App)LineType.CODEC.fieldOf("line_type2").forGetter(b -> b.lineType2), RoadWithAngleLine.isBevelCodec()).apply((Applicative)i, (settings, lineColor, lineColor2, lineType, lineType2, isBevel) -> new Impl((class_4970.class_2251)settings, (LineColor)((Object)((Object)lineColor)), (LineColor)((Object)((Object)lineColor2)), (LineType)((Object)((Object)lineType)), (LineType)((Object)((Object)lineType2)), (boolean)isBevel, null, null)));
        public final LineColor lineColor2;
        public final LineType lineType2;
        private final String lineSide2;
        private static final String[] NORMAL_PATTERN = new String[]{" a ", "bXX", " X "};
        private static final String[] HALF_THICK_PATTERN = new String[]{"aaa", "bXX", " X "};
        private static final String[] HALF_DOUBLE_PATTERN = new String[]{"ba ", " XX", "bX "};
        private static final String[] THICK_AND_DOUBLE_PATTERN = new String[]{"baa", "aXX", "bX "};

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineColor lineColor2, LineType lineType, LineType lineType2, boolean isBevel, String lineSide2, String lineTop) {
            super(settings, lineColor, lineType, isBevel, lineTop);
            this.lineColor2 = lineColor2;
            this.lineType2 = lineType2;
            this.lineSide2 = lineSide2;
        }

        @Override
        public LineColor getLineColor(class_2680 state, class_2350 direction) {
            return state.method_11654((class_2769)AXIS) == direction.method_10166() ? this.lineColor2 : this.lineColor;
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.diffAngleLine.composed.1", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
            tooltip.add((class_2561)TextBridge.translatable("lineType.diffAngleLine.composed.2", this.lineColor2.getName(), this.lineType2.getName()).method_27692(class_124.field_1078));
        }

        @Override
        public LineType getLineType(class_2680 state, class_2350 direction) {
            return state.method_11654((class_2769)AXIS) == direction.method_10166() ? this.lineType2 : this.lineType;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineSide(this.lineSide).lineSide2(this.lineSide2).lineTop(this.lineTop);
            class_2960 id = ((Road)road).uploadModel("_with_angle_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_TOP);
            class_2960 mirroredId = ((Road)road).uploadModel("_with_angle_line_mirrored", "_mirrored", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_TOP);
            class_4926.class_4928 map = class_4926.method_67865((class_2769)FACING, (class_2769)AXIS);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                @NotNull class_2350 offsetDirection1 = direction.method_10170();
                @NotNull HorizontalCornerDirection facing1 = HorizontalCornerDirection.fromDirections(direction, offsetDirection1);
                @NotNull class_2350 offsetDirection2 = direction.method_10160();
                @NotNull HorizontalCornerDirection facing2 = HorizontalCornerDirection.fromDirections(direction, offsetDirection2);
                class_10821 axisRotation = switch (direction) {
                    case class_2350.field_11039 -> class_10821.field_57030;
                    case class_2350.field_11043 -> class_10821.field_57031;
                    case class_2350.field_11034 -> class_10821.field_57032;
                    default -> class_10821.field_57029;
                };
                map.method_25798((Comparable)((Object)facing1), (Comparable)direction.method_10166(), (Object)class_4910.method_67835((class_2960)id).method_67929(class_10804.field_56937.withValue((Object)axisRotation))).method_25798((Comparable)((Object)facing2), (Comparable)direction.method_10166(), (Object)class_4910.method_67835((class_2960)mirroredId).method_67929(class_10804.field_56937.withValue((Object)axisRotation)));
            }
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_67852(road).method_67859((class_4926)map)));
        }

        protected MapCodec<? extends Impl> method_53969() {
            return CODEC;
        }

        private static String[] composePattern(LineType lineType, LineType lineType2) {
            if (lineType == LineType.THICK) {
                if (lineType2 == LineType.DOUBLE) {
                    return THICK_AND_DOUBLE_PATTERN;
                }
                if (lineType2 == LineType.NORMAL) {
                    return HALF_THICK_PATTERN;
                }
            } else if (lineType == LineType.NORMAL) {
                if (lineType2 == LineType.DOUBLE) {
                    return HALF_DOUBLE_PATTERN;
                }
                if (lineType2 == LineType.NORMAL) {
                    return NORMAL_PATTERN;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot determine patterns for [%s, %s]", lineType.method_15434(), lineType2.method_15434()));
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            String[] composePattern = Impl.composePattern(this.lineType, this.lineType2);
            class_2447 recipe = recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439(composePattern[0]).method_10439(composePattern[1]).method_10439(composePattern[2]).method_10433(Character.valueOf('a'), this.lineColor.getIngredient()).method_10433(Character.valueOf('b'), this.lineColor2.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base).method_10429("has_" + this.lineColor.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColor.getIngredient())).method_10429(class_2446.method_32807((class_1935)base), recipeGenerator.method_10426((class_1935)base));
            if (this.lineColor != this.lineColor2) {
                recipe.method_10429("has_" + this.lineColor2.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColor2.getIngredient()));
            }
            return recipe;
        }
    }
}

