/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_807;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.mixin.BlockStateModelGeneratorAccessor;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithJointLine
extends Road {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        Road.super.appendRoadProperties(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return RoadConnectionState.or(Road.super.getConnectionStateOf(state, direction), RoadConnectionState.of(state.method_11654(FACING) != direction.method_10153(), this.getLineColor(state, direction), EightHorizontalDirection.of(direction), this.getLineType(state, direction), null));
    }

    @Override
    default public class_2680 mirrorRoad(class_2680 state, class_2415 mirror) {
        return (class_2680)Road.super.mirrorRoad(state, mirror).method_11657(FACING, (Comparable)mirror.method_10343((class_2350)state.method_11654(FACING)));
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        return (class_2680)Road.super.rotateRoad(state, rotation).method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        class_2350 rotation = ctx.method_8042();
        return (class_2680)Road.super.withPlacementState(state, ctx).method_11657(FACING, (Comparable)(ctx.method_8036() != null && ctx.method_8036().method_5715() ? rotation.method_10153() : rotation));
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        Road.super.appendRoadTooltip(stack, context, tooltip, options);
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_joint_line.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_joint_line.2").method_27692(class_124.field_1080));
    }

    public static class Impl
    extends AbstractRoadBlock
    implements RoadWithJointLine {
        public final LineColor lineColorSide;
        public final LineType lineTypeSide;
        private final String lineTop;
        protected final String lineSide;
        protected final String lineSide2;
        public static final MapCodec<Impl> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Impl.method_54096(), Impl.lineColorFieldCodec(), (App)LineColor.CODEC.fieldOf("line_color_side").forGetter(b -> b.lineColorSide), Impl.lineTypeFieldCodec(), (App)LineType.CODEC.fieldOf("line_type_side").forGetter(b -> b.lineTypeSide)).apply((Applicative)i, (settings, lineColor, lineColorSide, lineType, lineTypeSide) -> new Impl((class_4970.class_2251)settings, (LineColor)((Object)((Object)lineColor)), (LineColor)((Object)((Object)lineColorSide)), (LineType)((Object)((Object)lineType)), (LineType)((Object)((Object)lineTypeSide)), null)));

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineColor lineColorSide, LineType lineType, LineType lineTypeSide, String lineTop) {
            super(settings, lineColor, lineType);
            this.lineColorSide = lineColorSide;
            this.lineTypeSide = lineTypeSide;
            this.lineTop = lineTop;
            this.lineSide = MishangUtils.composeStraightLineTexture(this.lineColor, this.lineType);
            this.lineSide2 = MishangUtils.composeStraightLineTexture(this.lineColorSide, this.lineTypeSide);
        }

        @Override
        public LineColor getLineColor(class_2680 blockState, class_2350 direction) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            if (facing == direction) {
                return this.lineColorSide;
            }
            if (facing == direction.method_10153()) {
                return LineColor.NONE;
            }
            return this.lineColor;
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.joint.composed", this.lineColor.getName(), this.lineType.getName(), this.lineColorSide.getName(), this.lineTypeSide.getName()).method_27692(class_124.field_1078));
        }

        @Override
        public LineType getLineType(class_2680 blockState, class_2350 direction) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            if (facing == direction) {
                return this.lineTypeSide;
            }
            if (facing == direction.method_10153()) {
                return LineType.NORMAL;
            }
            return this.lineType;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineSide(this.lineSide).lineSide2(this.lineSide2).lineTop(this.lineTop);
            class_2960 modelId = ((Road)road).uploadModel("_with_joint_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_SIDE2);
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_67853(road, (class_807)class_4910.method_67835((class_2960)modelId)).method_25775(BlockStateModelGeneratorAccessor.getSOUTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS())));
        }

        protected MapCodec<? extends Impl> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            String pattern1 = switch (this.lineTypeSide) {
                default -> throw new MatchException(null, null);
                case LineType.NORMAL -> " a ";
                case LineType.DOUBLE -> "a a";
                case LineType.THICK -> "aaa";
            };
            Road base2 = RoadBlocks.getRoadBlockWithLine(this.lineColor, this.lineType);
            if (base instanceof class_2482) {
                base2 = base2.getRoadSlab();
            }
            class_2447 recipe = recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439(pattern1).method_10439("XXX").method_10433(Character.valueOf('a'), this.lineColorSide.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base2).method_10429("has_" + this.lineColorSide.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColorSide.getIngredient())).method_10429(class_2446.method_32807((class_1935)base2), recipeGenerator.method_10426((class_1935)base2));
            if (this.lineColorSide != this.lineColor) {
                recipe.method_10429("has_" + this.lineColor.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColor.getIngredient()));
            }
            return recipe;
        }
    }
}

