/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10804;
import net.minecraft.class_10821;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.MishangucProperties;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.block.RoadWithJointLine;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineOffset;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithJointLineWithOffsetSide
extends Road {
    public static final class_2754<HorizontalCornerDirection> FACING = MishangucProperties.HORIZONTAL_CORNER_FACING;
    public static final class_2769<class_2350.class_2351> AXIS = class_2741.field_12529;

    @Override
    public LineColor getLineColor(class_2680 var1, class_2350 var2);

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        Road.super.appendRoadProperties(builder);
        builder.method_11667(new class_2769[]{FACING, AXIS});
    }

    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return RoadConnectionState.of(((HorizontalCornerDirection)((Object)state.method_11654(FACING))).hasDirection(direction) || ((class_2350.class_2351)state.method_11654(AXIS)).method_10176(direction), this.getLineColor(state, direction), EightHorizontalDirection.of(direction.method_10153()), this.getLineType(state, direction), ((class_2350.class_2351)state.method_11654(AXIS)).method_10176(direction) ? null : new LineOffset(((HorizontalCornerDirection)((Object)state.method_11654(FACING))).getDirectionInAxis((class_2350.class_2351)state.method_11654(AXIS)), this.offsetLevel()));
    }

    @Override
    default public class_2680 mirrorRoad(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(FACING, (Comparable)((Object)((HorizontalCornerDirection)((Object)state.method_11654(FACING))).mirror(mirror)));
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        return (class_2680)((class_2680)state.method_11657(FACING, (Comparable)((Object)((HorizontalCornerDirection)((Object)state.method_11654(FACING))).rotate(rotation)))).method_11657(AXIS, (Comparable)MishangUtils.rotateAxis(rotation, axis));
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        HorizontalCornerDirection facing = HorizontalCornerDirection.fromRotation(ctx.method_8044());
        return (class_2680)((class_2680)state.method_11657(FACING, (Comparable)((Object)(ctx.method_8036() != null && ctx.method_8036().method_5715() ? facing.getOpposite() : facing)))).method_11657(AXIS, (Comparable)ctx.method_8042().method_10166());
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        Road.super.appendRoadTooltip(stack, context, tooltip, options);
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_joint_line_with_offset_side.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_joint_line_with_offset_side.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_joint_line_with_offset_side.3").method_27692(class_124.field_1080));
    }

    public int offsetLevel();

    public static class Impl
    extends AbstractRoadBlock
    implements RoadWithJointLineWithOffsetSide {
        private final LineColor lineColorSide;
        private final LineType lineTypeSide;
        protected final String lineSide;
        protected final String lineSide2;
        protected final String lineTop;
        private final int offsetLevel;
        public static final MapCodec<Impl> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Impl.method_54096(), Impl.lineColorFieldCodec(), (App)LineColor.CODEC.fieldOf("line_color_side").forGetter(b -> b.lineColorSide), Impl.lineTypeFieldCodec(), (App)LineType.CODEC.fieldOf("line_type_side").forGetter(b -> b.lineTypeSide), (App)Codec.INT.fieldOf("offset_leve").forGetter(b -> b.offsetLevel)).apply((Applicative)i, (settings, lineColor, lineColorSide, lineType, lineTypeSide, offsetLevel) -> new Impl((class_4970.class_2251)settings, (LineColor)((Object)((Object)lineColor)), (LineColor)((Object)((Object)lineColorSide)), (LineType)((Object)((Object)lineType)), (LineType)((Object)((Object)lineTypeSide)), null, (int)offsetLevel)));
        public static final BiMap<RoadWithJointLine.Impl, Impl> OFFSET_ROADS = HashBiMap.create();

        public Impl(class_4970.class_2251 settings, RoadWithJointLine.Impl block, String lineTop, int offsetLevel) {
            this(settings, block.lineColor, block.lineColorSide, block.lineType, block.lineTypeSide, lineTop, offsetLevel);
            OFFSET_ROADS.put((Object)block, (Object)this);
        }

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineColor lineColorSide, LineType lineType, LineType lineTypeSide, String lineTop, int offsetLevel) {
            super(settings, lineColor, lineType);
            this.lineColorSide = lineColorSide;
            this.lineTypeSide = lineTypeSide;
            this.lineTop = lineTop;
            this.offsetLevel = offsetLevel;
            this.lineSide = MishangUtils.composeStraightLineTexture(lineColor, lineType);
            this.lineSide2 = lineColorSide.method_15434() + "_offset_straight_line";
        }

        @Override
        public int offsetLevel() {
            return this.offsetLevel;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineSide(this.lineSide).lineSide2(this.lineSide2).lineTop(this.lineTop);
            class_2960 modelId = ((Road)road).uploadModel("_with_joint_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_TOP);
            class_2960 mirroredModelId = ((Road)road).uploadModel("_with_joint_line_mirrored", "_mirrored", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_TOP);
            class_4926.class_4928 map = class_4926.method_67865((class_2769)FACING, (class_2769)AXIS);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                @NotNull class_2350 offsetDirection1 = direction.method_10170();
                @NotNull HorizontalCornerDirection facing1 = HorizontalCornerDirection.fromDirections(direction, offsetDirection1);
                @NotNull class_2350 offsetDirection2 = direction.method_10160();
                @NotNull HorizontalCornerDirection facing2 = HorizontalCornerDirection.fromDirections(direction, offsetDirection2);
                class_10821 axisRotation = switch (direction) {
                    case class_2350.field_11039 -> class_10821.field_57030;
                    case class_2350.field_11043 -> class_10821.field_57031;
                    case class_2350.field_11034 -> class_10821.field_57032;
                    default -> class_10821.field_57029;
                };
                map.method_25798((Comparable)((Object)facing1), (Comparable)offsetDirection1.method_10166(), (Object)class_4910.method_67835((class_2960)modelId).method_67929(class_10804.field_56937.withValue((Object)axisRotation))).method_25798((Comparable)((Object)facing2), (Comparable)offsetDirection2.method_10166(), (Object)class_4910.method_67835((class_2960)mirroredModelId).method_67929(class_10804.field_56937.withValue((Object)axisRotation)));
            }
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_67852(road).method_67859((class_4926)map)));
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.jointWithOffsetSide.composed.1", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
            tooltip.add((class_2561)TextBridge.translatable("lineType.jointWithOffsetSide.composed.2", this.lineColorSide.getName(), this.lineTypeSide.getName()).method_27692(class_124.field_1078));
        }

        @Override
        public LineColor getLineColor(class_2680 state, class_2350 direction) {
            if (((HorizontalCornerDirection)((Object)state.method_11654((class_2769)FACING))).hasDirection(direction) && !((class_2350.class_2351)state.method_11654(AXIS)).method_10176(direction)) {
                return this.lineColorSide;
            }
            return super.getLineColor(state, direction);
        }

        @Override
        public LineType getLineType(class_2680 state, class_2350 direction) {
            if (((HorizontalCornerDirection)((Object)state.method_11654((class_2769)FACING))).hasDirection(direction) && !((class_2350.class_2351)state.method_11654(AXIS)).method_10176(direction)) {
                return this.lineTypeSide;
            }
            return super.getLineType(state, direction);
        }

        protected MapCodec<? extends Impl> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            if (this.lineTypeSide != LineType.NORMAL) {
                throw new UnsupportedOperationException(String.format("Recipe for the block [lineTypeSide=%s] is not supported", this.lineTypeSide.method_15434()));
            }
            Road base2 = RoadBlocks.getRoadBlockWithLine(this.lineColor, this.lineType);
            if (base instanceof class_2482) {
                base2 = base2.getRoadSlab();
            }
            class_2447 recipe = recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439("a  ").method_10439("XXX").method_10433(Character.valueOf('a'), this.lineColorSide.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base2).method_10429("has_" + this.lineColorSide.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColorSide.getIngredient())).method_10429(class_2446.method_32807((class_1935)base2), recipeGenerator.method_10426((class_1935)base2));
            if (this.lineColorSide != this.lineColor) {
                recipe.method_10429("has_" + this.lineColor.method_15434() + "_paint", recipeGenerator.method_10420(this.lineColor.getIngredient()));
            }
            return recipe;
        }
    }
}

